import React from 'react';
import SectionMessage from '@atlaskit/section-message';
import { I18n } from '@atlassian/wrm-react-i18n';

export function LoadingDetailsErrorMessage({
    isOauth2NotSupportedError = false,
}: {
    isOauth2NotSupportedError?: boolean;
}) {
    return (
        <SectionMessage
            appearance="error"
            title={I18n.getText(
                'applinks-atlassian-oauth2-ui.incoming-link-data-loading-failed.title'
            )}
        >
            <p>
                {isOauth2NotSupportedError
                    ? I18n.getText(
                          'applinks-atlassian-oauth2-ui.incoming-link-creation-failed.oauth2-not-supported.description'
                      )
                    : I18n.getText(
                          'applinks-atlassian-oauth2-ui.incoming-link-data-loading-failed.description'
                      )}
            </p>
        </SectionMessage>
    );
}
