import { dispatchApplinkDialogClosedEvent } from '../atlassianOauth2UiEvents';

export const resetCredentialsDialogInitialState = {
    clientId: null,
    applinkId: null,
    isResetting: false,
    hasResetError: false,
    hasResetSuccess: false,
    isOpen: false,
};

export function resetCredentialsDialogReducer(substate, action) {
    switch (action.type) {
        case 'rcd:openResetFromEvent': {
            const { detail } = action;
            const { clientId, applinkId } = detail;
            return {
                ...substate,
                clientId,
                applinkId,
                isOpen: true,
            };
        }
        case 'rcd:resetStart': {
            return {
                ...substate,
                isResetting: true,
            };
        }
        case 'rcd:resetSuccess': {
            return {
                ...substate,
                isResetting: false,
                hasResetSuccess: true,
                hasResetError: false,
            };
        }
        case 'rcd:resetError': {
            return {
                ...substate,
                isResetting: false,
                hasResetError: true,
                hasResetSuccess: false,
            };
        }
        case 'rcd:resetClose': {
            dispatchApplinkDialogClosedEvent();
            return {
                ...substate,
                hasResetError: false,
                hasResetSuccess: false,
                isOpen: false,
            };
        }
    }
    return substate;
}
