import { dispatchApplinkDialogClosedEvent } from '../atlassianOauth2UiEvents';

export const revokeCredentialsDialogInitialState = {
    rotatedClientId: null,
    clientEntityId: null,
    isRevoking: false,
    hasRevokeError: false,
    hasRevokeSuccess: false,
    isOpen: false,
};

export function revokeCredentialsDialogReducer(substate, action) {
    switch (action.type) {
        case 'rcd:openRevokeFromEvent': {
            const { detail } = action;
            const { rotatedClientId, clientEntityId } = detail;
            return {
                ...substate,
                rotatedClientId,
                clientEntityId,
                isOpen: true,
            };
        }
        case 'rcd:revokeStart': {
            return {
                ...substate,
                isRevoking: true,
            };
        }
        case 'rcd:revokeSuccess': {
            return {
                ...substate,
                isRevoking: false,
                hasRevokeSuccess: true,
                hasRevokeError: false,
            };
        }
        case 'rcd:revokeError': {
            return {
                ...substate,
                isRevoking: false,
                hasRevokeError: true,
                hasRevokeSuccess: false,
            };
        }
        case 'rcd:revokeClose': {
            dispatchApplinkDialogClosedEvent();
            return {
                ...substate,
                hasRevokeError: false,
                hasRevokeSuccess: false,
                isOpen: false,
            };
        }
    }
    return substate;
}
