export function getPrefix() {
    return `${AJS.contextPath()}/rest/oauth2/latest/client`;
}

export async function postRevokeCredentials(clientEntityId) {
    const url = `${getPrefix()}/revoke/rotated/${clientEntityId}`;

    const response = await fetch(url, {
        method: 'DELETE',
        headers: {
            'Content-Type': 'application/json',
            'X-Atlassian-Token': 'no-check',
            'Accept': 'application/json',
            'Cache-Control': 'no-cache',
        },
    });

    if (!response.ok) {
        throw new Error('postRevokeCredentials: response not ok: ' + response.statusText);
    }

    return await response.json();
}
