import whenDomReady from 'when-dom-ready';
import { initAtlassianOauth2Ui } from './AtlassianOauth2UiPage';

whenDomReady().then(() => {
    const rootElement = document.getElementById('applinks-atlassian-oauth2-ui-root');

    if (!rootElement) {
        // The feature is not enabled.
        console.debug(
            '#applinks-atlassian-oauth2-ui-root not found: skip initialization of Atlassian OAuth2 flow'
        );
        return;
    }

    initAtlassianOauth2Ui(rootElement);
});
