import Ajv from 'ajv';
const ajv = new Ajv();

const intermediateIncomingApplicationLinkDetailsSchema = {
    type: 'object',
    properties: {
        id: { type: 'string' },
        name: { type: 'string' },
        rpcUrl: { type: 'string' },
        displayUrl: { type: 'string' },
        incomingClientId: { type: 'string' },
        incomingClientSecret: { type: 'string' },
        incomingRedirectUri: { type: 'string' },
        readonlyRedirectUri: { type: 'boolean' },
        availableIncomingScopes: {
            type: 'array',
            items: { type: 'string' },
        },
        incomingScopes: { type: 'string' },
    },
    required: ['id', 'rpcUrl', 'displayUrl', 'readonlyRedirectUri'],
    additionalProperties: true,
};

const validateIntermediateIncomingApplicationLinkDetails = ajv.compile(
    intermediateIncomingApplicationLinkDetailsSchema
);

export function getIntermediateIncomingApplicationLinkDetailsFromResponseData(responseData) {
    const valid = validateIntermediateIncomingApplicationLinkDetails(responseData);
    if (!valid) {
        console.error(
            'getIntermediateIncomingApplicationLinkDetailsFromResponseData: schema validation errors',
            ...validateIntermediateIncomingApplicationLinkDetails.errors
        );
        throw new Error(
            `intermediateIncomingApplicationLinkDetails doesn't conform to schema: ${JSON.stringify(
                responseData
            )}`
        );
    } else {
        return responseData;
    }
}

const finalIncomingApplicationLinkDetailsSchema = {
    type: 'object',
    properties: {
        id: { type: 'string' },
        name: { type: 'string' },
        rpcUrl: { type: 'string' },
        displayUrl: { type: 'string' },
        incomingRedirectUri: { type: 'string' },
        readonlyRedirectUri: { type: 'boolean' },
        incomingScopes: { type: 'string' },
        incomingClientId: { type: 'string' },
        incomingClientSecret: { type: 'string' },
    },
    required: [
        'id',
        'rpcUrl',
        'displayUrl',
        'incomingRedirectUri',
        'incomingScopes',
        'incomingClientId',
        'incomingClientSecret',
    ],
    additionalProperties: false,
};

const validateFinalIncomingApplicationLinkDetails = ajv.compile(
    finalIncomingApplicationLinkDetailsSchema
);

export function getFinalIncomingApplicationLinkDetailsFromResponseData(responseData) {
    const valid = validateFinalIncomingApplicationLinkDetails(responseData);
    if (!valid) {
        console.error(
            'getFinalIncomingApplicationLinkDetailsFromResponseData: schema validation errors',
            ...validateFinalIncomingApplicationLinkDetails.errors
        );
        throw new Error(
            `finalIncomingApplicationLinkDetails doesn't conform to schema: ${JSON.stringify(
                responseData
            )}`
        );
    } else {
        return responseData;
    }
}
