import { I18n } from '@atlassian/wrm-react-i18n';
import Button from '@atlaskit/button/new';
import React, { Component } from 'react';

const windowName = 'com_atlassian_applinks_authentication';

export function authorize(url?: string, callback?: () => void) {
    if (!url) {
        console.error('No URL provided for authorization');
        return;
    }
    // eslint-disable-next-line prefer-const
    let authWindow: Window | null;
    window.oauthCallback = {
        success: () => {
            console.log('sucessfully authenticated');
            if (callback) {
                callback();
            }
            if (authWindow) {
                authWindow.close();
            }
        },
    };
    authWindow = window.open(url, windowName);
}

interface AuthButtonProps {
    url: string;
    successCallback?: () => void;
    currentApp: string;
}

export default class AuthButton extends Component<AuthButtonProps> {
    authorize() {
        return authorize(this.props.url, this.props.successCallback);
    }

    render() {
        return (
            <Button appearance="primary" testId="auth-button" onClick={() => this.authorize()}>
                {I18n.getText('entitylinks.dialog.authorize', this.props.currentApp)}
            </Button>
        );
    }
}
