import { ConfigContext, Root, type ConfigContextType } from '@atlassian/dc-applinks-uniconn';
import React from 'react';
import { createRoot } from 'react-dom/client';
import whenDomReady from 'when-dom-ready';

const config: ConfigContextType = {
    uniconnApiBaseUrl: `${AJS.contextPath()}/rest/applinks/3.0/uniconn`,
};

whenDomReady().then(() => {
    const container = document.getElementById('applinks-cloud-connections-page-root');

    if (!container) {
        console.debug('#applinks-cloud-connections-page-root not found');
        return;
    }

    createRoot(container).render(
        <ConfigContext.Provider value={config}>
            <Root />
        </ConfigContext.Provider>
    );
});
