define('confluence/page-hierarchy/fetch/fetch-attachment-count', [
    'jquery',
    'wrm/context-path'
], function (
    $,
    contextPath) {
    var ENDPOINT = '/rest/page-hierarchy/internal/attachmentCount/';

    /**
     * Gets the real count of attachments of a page.
     * @param {number|string} pageId The ID of the page of which get the count of attachment
     * @returns {jQuery.Deferred} with the count as the result.
     */
    function fetchAttachmentCount(pageId) {
        var deferred = $.Deferred();
        $.ajax({
            url: contextPath() + ENDPOINT + pageId,
            success: function (data) {
                deferred.resolve(data.count);
            }, error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

    return fetchAttachmentCount;
});