define('confluence/page-hierarchy/fetch/fetch-homepage', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/api/space/<spaceKey>?expand=homepage';

    /**
     * Fetch the home page for a space from REST
     * @param {string} spaceKey The space key
     * @returns {jQuery.Deferred} with the result
     */
    function fetchHomepage(spaceKey) {
        var deferred = AJS.$.Deferred();
        AJS.$.ajax({
            url: AJS.contextPath() + ENDPOINT.replace('<spaceKey>', spaceKey),
            success: function (data) {
                deferred.resolve(data.homepage);
            }, error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

    return fetchHomepage;
});