define('confluence/page-hierarchy/fetch/fetch-incoming-link-count', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/page-hierarchy/internal/incomingLinkCount/<pageId>';

    /**
     * Gets the real count of incoming links for a page. Does not exclude any links.
     * @param {number|string} pageId The Page Id to get the links for
     * @returns {jQuery.Deferred} with the count as the result.
     */
    function fetchIncomingLinkCount(pageId) {
        var deferred = AJS.$.Deferred();
        AJS.$.ajax({
            url: AJS.contextPath() + ENDPOINT.replace('<pageId>', pageId),
            success: function (data) {
                deferred.resolve(data.count);
            }, error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

    return fetchIncomingLinkCount;
});