define('confluence/page-hierarchy/fetch/fetch-subtree-count', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/page-hierarchy/internal/subtreeCount/<pageId>';

    /**
     * Gets the number of descendants and restricted descendants in the tree useful
     * for telling the user how many pages will be deleted and how many pages will be left behind.
     * @param {number|string} pageId The Page Id to get the links for
     * @param {boolean} totalCountOnly Optional: if true, will return just the total count, and not the restricted
     *                                              count or the count of pages with incoming links.
     * @returns {jQuery.Deferred} with the counts as the result.
     */
    function fetchSubtreeCount(pageId, totalCountOnly) {
        var deferred = AJS.$.Deferred();
        var url = AJS.contextPath() + ENDPOINT.replace('<pageId>', pageId);
        if (totalCountOnly) {
            url += '?totalCountOnly=true';
        }
        AJS.$.ajax({
            url: url,
            success: function (data) {
                deferred.resolve(data);
            }, error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

    return fetchSubtreeCount;
});