define('confluence/page-hierarchy/service/delete-service', [
    'ajs',
    'confluence/page-hierarchy/state/delete-state',
    'confluence/page-hierarchy/action/delete-page-hierarchy-action',
    'confluence/page-hierarchy/util/execute-if-function',
    'confluence/page-hierarchy/util/analytics-event',
    'confluence/page-hierarchy/util/validation-error'
], function (AJS,
             state,
             deletePageHierarchyAction,
             executeIfFunction,
             analyticsEvent,
             validationError) {

    var TASK_ID_KEY = 'taskId';

    /**
     * A service that manages the delete action.
     * @param {object} options Options. See usage for which options are available.
     * @returns {undefined}
     * @constructor
     */
    var DeleteService = function (options) {
        this.loadingIndicator = options.loadingIndicator;
        this.beforeSubmit = options.beforeSubmit;
        this.dialog = options.dialog;
    };

    /**
     * Submit the request to copy page hierarchy.
     * @returns {object} The promise object returned by the copyPageHierarchyAction.
     * @private
     */
    DeleteService.prototype.submit = function () {
        this.loadingIndicator.loading();
        executeIfFunction(this.beforeSubmit);
        state.clearErrors();
        return deletePageHierarchyAction(state.getOptions())
            .done(this.success.bind(this))
            .fail(this.fail.bind(this));
    };

    /**
     * Success callback runs when the task is successfully submitted.
     * @param {object} data  Data retrieved from the server. Contains the taskId.
     * @returns {undefined}
     * @private
     */
    DeleteService.prototype.success = function (data) {
        var taskId = data[TASK_ID_KEY];
        this.loadingIndicator.done();
        state.setTaskId(taskId);
        AJS.trigger(state.DELETE_HIERARCHY_SUBMIT_EVENT);
    };

    /**
     * Fail callback runs when the request to submit the task fails.
     * @param {object} errorResponse Error response from the server.
     * @returns {undefined}
     * @private
     */
    DeleteService.prototype.fail = function (errorResponse) {
        validationError.fail(errorResponse, analyticsEvent.DELETE_HIERARCHY_ERROR_EVENT, this.dialog, state.ERROR_MESSAGES);
    };

    return DeleteService;
});