define("confluence-space-ia/avatar-picker/image-explorer",["jquery","underscore"],function(k,g){function b(a,d){this.init.apply(this,arguments)}b.scaleModes={fill:"fill",contain:"contain",containAndFill:"containAndFill"};b.zoomModes={localZoom:"localZoom",imageZoom:"imageZoom"};b.prototype.defaults={initialScaleMode:b.scaleModes.containAndFill,zoomMode:b.zoomModes.localZoom,emptyClass:"empty",scaleMax:1};b.prototype.init=function(a,d){this.$container=a;this.$imageView=this.$container.find(".image-explorer-image-view");
this.$sourceImage=this.$container.find(".image-explorer-source");this.$mask=this.$container.find(".image-explorer-mask");this.$dragDelegate=this.$container.find(".image-explorer-drag-delegate");this.$scaleSlider=this.$container.find(".image-explorer-scale-slider");this.options=k.extend({},this.defaults,d);this.imageProperties={};g.bindAll(this,"getImageSrc","setImageSrc","initImage","initDragDelegate","initScaleSlider","setInitialScale","getFillScale","getContainedScale","getCircularContainedScale",
"sliderValToScale","scaleToSliderVal","updateImageScale","resetImagePosition","resetScaleSlider","toggleEmpty","get$ImageView","get$SourceImage","get$Mask","get$DragDelegate","getMaskedImageProperties","showError","clearError","hasValidImage","_resetFromError","_removeError");this.toggleEmpty(!0);this.$sourceImage[0].naturalWidth&&(this.toggleEmpty(!1),this.initImage({target:this.$sourceImage[0]}));this.$sourceImage.on("load",this.initImage);this.initDragDelegate();this.initScaleSlider()};b.prototype.getImageSrc=
function(){return this.$sourceImage?this.$sourceImage.attr("src"):void 0};b.prototype.setImageSrc=function(a){this.$sourceImage&&this.$sourceImage.attr("src","").attr("src",a)};b.prototype.initImage=function(a){a=a.target;this.imageProperties.naturalWidth=a.naturalWidth;this.imageProperties.naturalHeight=a.naturalHeight;this._removeError();this.toggleEmpty(!1);this.setInitialScale()};b.prototype.initDragDelegate=function(){var a;this.$dragDelegate.draggable({start:g.bind(function(){a=this.$sourceImage.offset()},
this),drag:g.bind(function(d,c){this.$sourceImage.offset({top:a.top+c.position.top-c.originalPosition.top,left:a.left+c.position.left-c.originalPosition.left})},this),revert:!0,revertDuration:0})};b.prototype.initScaleSlider=function(){this.$scaleSlider.on("change",g.bind(function(a){this.updateImageScale(this.sliderValToScale(a.target.value))},this))};b.prototype.setInitialScale=function(){var a=this.$mask.width(),d=this.$mask.height(),c=this.imageProperties.naturalWidth,e=this.imageProperties.naturalHeight,
f=1;this.minScale=1;switch(this.options.initialScaleMode){case b.scaleModes.fill:this.minScale=f=this.getFillScale(c,e,a,d);break;case b.scaleModes.contain:this.$mask.hasClass("circle-mask")?this.minScale=f=this.getCircularContainedScale(c,e,a/2):this.minScale=f=this.getContainedScale(c,e,a,d);break;case b.scaleModes.containAndFill:this.$mask.hasClass("circle-mask")?this.minScale=this.getCircularContainedScale(c,e,a/2):this.minScale=this.getContainedScale(c,e,a,d),f=this.getFillScale(c,e,a,d)}this.maxScale=
Math.max(f,this.options.scaleMax);this.resetScaleSlider(this.scaleToSliderVal(f));this.updateImageScale(f,b.zoomModes.imageZoom);this.resetImagePosition()};b.prototype.getFillScale=function(a,d,c,e){return Math.max(c/a,e/d)};b.prototype.getContainedScale=function(a,d,c,e){return Math.min(c/a,e/d)};b.prototype.getCircularContainedScale=function(a,d,c){return Math.cos(Math.atan(d/a))*c*2/a};b.prototype.sliderValToScale=function(a){a/=this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min");return this.minScale+
a*(this.maxScale-this.minScale)};b.prototype.scaleToSliderVal=function(a){return(a-this.minScale)/(this.maxScale-this.minScale)*(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"))};b.prototype.updateImageScale=function(a,d){var c=Math.round(a*this.imageProperties.naturalWidth);a=Math.round(a*this.imageProperties.naturalHeight);d=d||this.options.zoomMode;switch(d){case b.zoomModes.imageZoom:var e=-1*c/2;var f=-1*a/2;break;case b.zoomModes.localZoom:e=this.$sourceImage.width();d=this.$sourceImage.height();
var n=parseInt(this.$sourceImage.css("margin-left"),10),h=parseInt(this.$sourceImage.css("margin-top"),10);f=this.$sourceImage.position();var l=this.$imageView.width()/2,m=this.$imageView.height()/2;h=m-f.top-h;e=l-f.left-(l-f.left-n)/e*c;f=m-f.top-h/d*a}this.$sourceImage.width(c).height(a).css({"margin-left":Math.round(e)+"px","margin-top":Math.round(f)+"px"})};b.prototype.resetImagePosition=function(){this.$sourceImage.css({top:"50%",left:"50%"})};b.prototype.resetScaleSlider=function(a){this.$scaleSlider.val(a).removeClass("disabled").prop("disabled",
!1)};b.prototype.toggleEmpty=function(a){this.$container.toggleClass(this.options.emptyClass,a)};b.prototype.get$ImageView=function(){return this.$imageView};b.prototype.get$SourceImage=function(){return this.$sourceImage};b.prototype.get$Mask=function(){return this.$mask};b.prototype.get$DragDelegate=function(){return this.$dragDelegate};b.prototype.getMaskedImageProperties=function(){var a=this.$sourceImage.width()/this.imageProperties.naturalWidth,d=this.$sourceImage.height()/this.imageProperties.naturalHeight,
c=this.$mask.position(),e=this.$sourceImage.position();c.top+=parseInt(this.$mask.css("margin-top"),10);c.left+=parseInt(this.$mask.css("margin-left"),10);e.top+=parseInt(this.$sourceImage.css("margin-top"),10);e.left+=parseInt(this.$sourceImage.css("margin-left"),10);return{maskedAreaImageX:Math.round((c.left-e.left)/a),maskedAreaImageY:Math.round((c.top-e.top)/d),maskedAreaWidth:Math.round(this.$mask.width()/a),maskedAreaHeight:Math.round(this.$mask.height()/d)}};b.prototype.showError=function(a,
d){this._removeError();this.toggleEmpty(!0);this.$container.addClass("error");a=k(aui.message.error({titleContent:a,content:d||"",closeable:!0}));a.appendTo(this.$imageView).css({"margin-top":-1*a.outerHeight()/2}).attr("id","upload-error-message");a.on("messageClose",this._resetFromError);AJS.messages.setup()};b.prototype.clearError=function(){this._removeError();this._resetFromError()};b.prototype.hasValidImage=function(){return!(!this.getImageSrc()||!this.$sourceImage.prop("naturalWidth"))};b.prototype._resetFromError=
function(){var a=this.hasValidImage();this.toggleEmpty(!a);this.$container.removeClass("error");g.isFunction(this.options.onErrorReset)&&this.options.onErrorReset(a?this.getImageSrc():void 0)};b.prototype._removeError=function(){this.$imageView.find(".aui-message.aui-message-error").remove();this.$imageView.find(".aui-message.error").remove()};return b});