(function($) {
    var quickLinksFlyout, childPagesFlyout, pageTreeFlyout;

    function getElem(selector) {
        var $elem = $(selector);
        if(!$elem.selector){
            // selector property has been removed in jquery version 3 and inlineDialog uses it internally.
            // this can be removed when we start using inlineDialog2 or some other method which does not rely on
            // this property.
            $elem.selector = selector
        }
        return $elem;
    }

    Confluence.Sidebar.createFlyouts = function($sidebar) {
        quickLinksFlyout = createFlyout(
            getElem('.collapsed button.quick-links-section-button'),
            Confluence.Sidebar.Pages.quickLinksContent,
            'sidebar-quick-links-flyout',
            {flyout: 'quick-links'}
        );

        var contextualNav = $sidebar.find('.ia-secondary-container');
        if (contextualNav.length && contextualNav.attr('data-tree-type') == 'pages') {
            childPagesFlyout = createFlyout(
                getElem('.collapsed .ia-secondary-header-title.wiki button'),
                Confluence.Sidebar.Pages.childPageCollapsedContent,
                'sidebar-children-flyout',
                {flyout: 'children'}
            );
        }

        if (contextualNav.length && contextualNav.attr('data-tree-type') == 'page-tree') {
            pageTreeFlyout = createFlyout(
                getElem('.collapsed .ia-secondary-header-title.page-tree button'),
                Confluence.Sidebar.Pages.pageTreeCollapsedContent,
                'sidebar-page-tree-flyout',
                {flyout: 'pagetree'}
            );
        }
    };

    function createFlyout($trigger, contentFn, identifier, analyticsData) {
        var dialogLoadOverride = function($content, trigger, showPopup) {
            $content.addClass('acs-side-bar-flyout ia-scrollable-section');
            $content.empty().append(Confluence.Sidebar.throbberDiv());
            contentFn().done(function(html) {
                $content.html(html);
            });
            AJS.trigger('sidebar.flyout-triggered', analyticsData);
            showPopup();

            //Change implementation when https://ecosystem.atlassian.net/browse/AUI-1175 is done
            $(trigger).one('click', function(e) {
                if($('#inline-dialog-'+identifier).is(':visible')) {
                    setTimeout(function() { //Make sure we execute hide after show in this case
                        flyout.hide();
                    },0);
                }
            });
            AJS.trigger('sidebar.disable-tooltip', trigger);
            return $content;
        };

        var inlineDialog = require('confluence/inline-dialog');
        inlineDialog = inlineDialog.inlineDialog || inlineDialog;
        var flyout = inlineDialog($trigger, identifier, dialogLoadOverride, {
            gravity: 'w',
            calculatePositions: calculateFlyoutPositions,
            useLiveEvents: true,
            hideDelay: null,
            hideCallback: function() {
                AJS.trigger('sidebar.enable-all-tooltips');
            }
        });

        AJS.bind('sidebar.hide-overlays', flyout.hide);

        return flyout;
    }

    function calculateFlyoutPositions(popup, targetPosition, mousePosition, opts) {
        var targetOffset = targetPosition.target.offset();
        var targetWidth = targetPosition.target.width();
        var targetHeight = targetPosition.target.height();
        var popupCss = {
            top: targetOffset.top + targetHeight/2 - 15,
            left: targetOffset.left + targetWidth + 5,
            right: 'auto'
        };

        // Set the max height of the flyout so that it doesn't extend past the bottom edge of the viewport
        var $window = $(window);
        var gapFromBottomOfViewport = 20;
        popupCss.maxHeight = $window.height() + $window.scrollTop() - popupCss.top - gapFromBottomOfViewport;

        var arrowCss = {
            top: 9
        };

        return {
            popupCss: popupCss,
            arrowCss: arrowCss,
            gravity: 'w'
        };
    }
})(AJS.$);
