(function($) {
    const contextPath = AJS.Meta.get('context-path');
    const atlToken = AJS.Meta.get('atl-token');

    Confluence.Sidebar.Pages = {
        installHandlers: function($sidebar) {
            $sidebar.find('.more-children-link').click(function(e) {
                e.preventDefault();
                $sidebar.find('ul.more-children').show();
                $(this).hide();
            });
        },
        quickLinksContent: function() {
            let $quickLinksWrapper = $('.acs-side-bar .quick-links-wrapper').clone();
            // Remove hidden button to avoid focus issues
            $quickLinksWrapper.find('.sidebar-flyout-button.quick-links-section-button').remove()

            return new $.Deferred().resolve($quickLinksWrapper.html());
        },
        childPageCollapsedContent: function() {
            let $header = $('.acs-side-bar .ia-secondary-header');
            let $parentPage = $('.acs-side-bar .ia-secondary-parent-content').clone();
            let $currentPage = $('.acs-side-bar .ia-secondary-current-content');
            let $contextualNav = $('.acs-side-bar .ia-secondary-content');

            // Remove hidden button to avoid focus issues
            $parentPage.find('#child-pages-button').remove()

            return new $.Deferred().resolve($('<div>')
                .append($('<div>')
                    .addClass('acs-side-bar-flyout-wiki-wrapper')
                    .append($header.clone())
                    .append($parentPage.clone())
                    .append($currentPage.clone())
                    .append($contextualNav.clone()))
                .html());
        },
        pageTreeCollapsedContent: function() {
            let pageTreeFlyoutContent = $('.page-tree-flyout-content');

            if (pageTreeFlyoutContent.length == 0) {
                return getPageTreeFlyoutContent().then(function(contextualNavData) {
                    let renderedContent = $('<div>').addClass('acs-side-bar-flyout-wiki-wrapper').append(
                        Confluence.Templates.Sidebar.Pages.renderPageContextualNav({
                            pageContextualNav: contextualNavData,
                            hasCreatePermission: $('.acs-nav').data('has-create-permission'),
                            atlToken: atlToken
                        })
                    );

                    let renderedContentClone = renderedContent.clone()
                    // Remove hidden button to avoid focus issues
                    renderedContentClone.find('.sidebar-flyout-button').remove()

                    $('body').append($('<div>')
                        .addClass('page-tree-flyout-content hidden')
                        .append(renderedContentClone));

                    return renderedContent;
                });
            } else {
                return new $.Deferred().resolve(pageTreeFlyoutContent.html());
            }
        }
    };

    function getPageTreeFlyoutContent() {
        return $.ajax({
            url: contextPath + "/rest/ia/1.0/space/childPagesContextualNav",
            data: {pageId: AJS.Meta.get('page-id')}
        });
    }
})(AJS.$);