define('confluence-space-ia/sidebar-space-tools', [
    'ajs',
    'jquery',
    'confluence/legacy'
], function(
    AJS,
    $,
    Confluence
) {
    function SidebarSpaceTools() {
        var spaceToolLinks = [];
        var spaceLinks = [];
        var $spaceToolsMenu = $('#space-tools-menu');

        var $expandCollapseTrigger;

        // spaceToolsLinks and spaceLinks content comes from the DOM where it exists as a header menu that's displayed in
        // documentation theme, but hidden in the global theme (this is the theme that contains the sidebar). In the global
        // theme, the menu is instead presented in the bottom of the sidebar as "Configure sidebar". The items placed in
        // the "Configure sidebar" menu are scraped from the DOM

        // Data for rendering the top-level Space Tools web items
        $('#space-tools-web-items').children('div').each(function() {
            spaceToolLinks.push({
                text: $(this).data('label'),
                href: $(this).data('href')
            });
        });

        // Data for rendering other space related links in the menu
        $('#space-tools-menu-additional-items').children('div').each(function() {
            spaceLinks.push({
                extraClasses: $(this).data('class'),
                text: $(this).data('label'),
                href: $(this).data('href')
            });
        });

        // Build space tools menu
        $spaceToolsMenu.replaceWith($(Confluence.Templates.Sidebar.spaceToolsMenu({
            spaceToolLinks: spaceToolLinks,
            spaceLinks: spaceLinks
        })));

        if (AJS && AJS.Confluence && AJS.Confluence.Analytics && AJS.Confluence.Analytics.setAnalyticsSource) {
            AJS.Confluence.Analytics.setAnalyticsSource($spaceToolsMenu.find('aui-item-link:not(.configure-sidebar)'), "spacetools");
        }

        // Collapse / expand trigger binding
        $expandCollapseTrigger = $('.expand-collapse-trigger');
        $expandCollapseTrigger.click(function(e) {
            e.preventDefault();
            Confluence.Sidebar.toggle();
        });
        $expandCollapseTrigger.attr('data-tooltip', $('.ia-fixed-sidebar').hasClass('collapsed') ? Confluence.Sidebar.expandTooltip : Confluence.Sidebar.collapseTooltip);
        $expandCollapseTrigger.attr('aria-label', Confluence.Sidebar.ariaLabel);
        AJS.bind('sidebar.collapsed', function() {
            $expandCollapseTrigger.attr('data-tooltip', Confluence.Sidebar.expandTooltip);
        });
        AJS.bind('sidebar.expanded', function() {
            $expandCollapseTrigger.attr('data-tooltip', Confluence.Sidebar.collapseTooltip);
        });
    }

    return SidebarSpaceTools;
});
