define('confluence/maintenance', [
    'underscore',
    'backbone'
], function(
    _,
    Backbone
) {
    'use strict';

    return Backbone.View.extend({
        events: {
            'click #readOnlyModeEnabled': 'toggleReadOnlyMode'
        },
        initialize: function() {
            _.bindAll(this, 'toggleReadOnlyMode');
        },
        toggleReadOnlyMode: function() {
            var isReadOnlyModeEnabled = this.$('#readOnlyModeEnabled').is(':checked');
            if (isReadOnlyModeEnabled) {
                // check and disable the banner message box
                this.$('#bannerMessageOn').prop('checked', true).prop('disabled', true);
            } else {
                // enable and uncheck the banner message box
                this.$('#bannerMessageOn').prop('disabled', false).prop('checked', false);
            }
        }
    });
});

require('confluence/module-exporter').safeRequire('confluence/maintenance', function(Maintenance) {
    'use strict';

    require('ajs').toInit(function() {
        new Maintenance({
            el: 'form[name=\'maintenance\']'
        });
    });
});
