AJS.toInit(function ($) {
    var pluginKey = "com.atlassian.confluence.plugins.confluence-jira-metadata";
    var dataLoaded = false; // only load inline dialog contents once
    var dialog;
    var dialogContents;
    var dialogId = "jira-metadata-dialog";
    var $webItem = $('#content-metadata-jira');
    var discoveryDialog;
    var discoveryDialogId = "jira-metadata-discovery";
    var initialCount = AJS.Meta.get("jira-metadata-count");
    var featureDiscoveryId = "linked-issues-dropdown";

    if(initialCount > 0) {
        enableWebItem(initialCount, AJS.Meta.get("jira-metadata-count-incomplete"));
    } else if (initialCount == -1) {
        $.ajax({
            url: AJS.contextPath() + "/rest/jira-metadata/1.0/metadata/aggregate?pageId=" + AJS.Meta.get("page-id"),
            type: "GET",
            dataType: "json",
            contentType: "application/json",
            cache: false,
            success: function (response) {
                if(response.count > 0) {
                    enableWebItem(response.count, response.incomplete);
                }
            }
        });
    }

    function enableWebItem(count, incomplete) {
        updateWebItemText(count, incomplete);
        $webItem.removeClass("hidden");

        if(shouldBindInlineDialog()) {
            dialog = AJS.InlineDialog($webItem, dialogId,
                    function(content, trigger, showPopup) {
                        AJS.trigger('analytics', {name: 'confluence.jira.metadata.expanded'});

                        if(!dialogContents || !dataLoaded) {
                            dialogContents = content;
                            showPopup();
                            updateInlineDialogContents(content);
                        } else {
                            showPopup();
                        }
                        return false;
                    }, { hideDelay: null });

            // Workaround to dismiss the inline dialog until https://ecosystem.atlassian.net/browse/AUI-1175 is done
            $webItem.click(function() {
                if($('#' + dialogId).is(':visible')) {
                    dialog.hide();
                }
            });
        }

        //Pop feature discovery if appropriate
        if($webItem && shouldShowFeatureDiscovery()) {
            showFeatureDiscoveryDialog();
            // Mark feature as discovered if user clicks the Jira link button: https://jira.atlassian.com/browse/CONF-32814
            $webItem.one("click", function() {
                Confluence.FeatureDiscovery.forPlugin(pluginKey).markDiscovered(featureDiscoveryId);
            });
        }
    }

    function updateWebItemText(count, incomplete) {
        if (!incomplete) {
            var iconEl = $('<span/>').addClass('aui-icon aui-icon-small aui-iconfont-jira');
            $('#content-metadata-jira').text(
                    count == 1 ? AJS.I18n.getText('content.metadata.jira.item') : AJS.I18n.getText('content.metadata.jira.items', count)
            ).prepend(iconEl);
        }
    }

    function shouldBindInlineDialog() {
        return !$webItem.attr('href'); // web-item might be a direct link to a single Jira entity
    }

    // Shows the feature discovery inline dialog immediately.
    function showFeatureDiscoveryDialog() {
        discoveryDialog = AJS.InlineDialog($webItem, discoveryDialogId, function(content, trigger, showPopup) {
            content.html(Confluence.Templates.Metadata.Jira.featureDiscovery());
            content.find(".showme").on("click", function() {
                Confluence.FeatureDiscovery.forPlugin(pluginKey).markDiscovered(featureDiscoveryId);
                discoveryDialog.hide();
                dialog.show();
            });
            content.find(".close").on("click", function() {
                Confluence.FeatureDiscovery.forPlugin(pluginKey).markDiscovered(featureDiscoveryId);
                discoveryDialog.hide();
            });
            showPopup();
        }, {
            noBind: true,
            closeOthers: false,
            hideDelay: null
        });
        discoveryDialog.show();
        Confluence.FeatureDiscovery.forPlugin(pluginKey).addDiscoveryView(featureDiscoveryId);
    }


    function shouldShowFeatureDiscovery() {
        // TODO: can get rid of this entirely once BP plugin is using feature discovery API also.
        return !AJS.Meta.get('blueprint-index-popup-key') &&
                Confluence.FeatureDiscovery.forPlugin(pluginKey).shouldShow(featureDiscoveryId);
    }

    function updateInlineDialogContents() {
        lockInlineDialogHeight(); // preserve existing dialog height when we replace the contents for the 'loading' state
        dialogContents.html(Confluence.Templates.Metadata.Jira.loadingMetadata());
        dialogContents.find(".spinner").spin("medium");

        $.ajax({
            url: AJS.contextPath() + "/rest/jira-metadata/1.0/metadata?pageId=" + AJS.Meta.get("page-id"),
            type: "GET",
            dataType: "json",
            contentType: "application/json",
            error:function (xhr) {
                unlockInlineDialogHeight();
                dialogContents.html(Confluence.Templates.Metadata.Jira.unknownError());
            },
            success: function (response) {
                unlockInlineDialogHeight();
                dataLoaded = true;

                updateWebItemText(response.count, false);

                var content;
                if(response.count === 0 && !(response.unauthorisedAppLinks && response.unauthorisedAppLinks.length > 0) && response.errors.length == 0) {
                    AJS.trigger('analytics', {name: 'confluence.jira.metadata.error.no-metadata'});
                    content = Confluence.Templates.Metadata.Jira.nometadata();
                }
                else {
                    content = Confluence.Templates.Metadata.Jira.metadata(response);
                }

                dialogContents.html(content);

                // We call this inside a setTimeout to force a re-layout, which makes the CSS animation trigger.
                setTimeout(function() {
                    dialogContents.find("#" + dialogId).addClass("show");
                }, 0);

                bindApplinkAuthLinks();
            },
            complete: function() {
                $('#' + dialogId + ' .icon-close').click(function(e) {
                    e.stopPropagation();
                    $(this).closest('.closable').remove()
                });
            }
        });
    }

    function bindApplinkAuthLinks() {
        $('.jira-metadata-auth-link').click(function(e) {
            e.preventDefault();
            AppLinks.authenticateRemoteCredentials($(this).data('href'), updateInlineDialogContents, function() {});
        });
    }

    function lockInlineDialogHeight() {
        if (dialogContents && dialogContents.height() > 0)
            dialogContents.css('height', dialogContents.height());
    }

    function unlockInlineDialogHeight() {
        dialogContents && dialogContents.css('height', '');
    }
});