/**
 * Trigger the like components as appropriate based on events from the Confluence Mobile plugin.
 * @module confluence-like/event-handler
 */
define('confluence-like/event-handler', [
    'confluence-mobile/legacy'
], function(
    ConfluenceMobile
) {
    'use strict';

    return function() {
        var contentRenderedHandler = function(pageView, $container, contentModel) {
            // Note: The Content model really shouldn't have likes and we should be retrieving
            // Likes in this plugin. However, to avoid an additional REST call we will leave it as it is.
            var likesCollection = new ConfluenceMobile.Likes(contentModel.get('likes'), {
                contentId: contentModel.contentId,
                contextPath: ConfluenceMobile.AppData.get('confluence-context-path')
            });

            $container.append(new ConfluenceMobile.LikeView({
                collection: likesCollection,
                currentUser: ConfluenceMobile.AppData.getObject('current-user')
            }).render().el);
        };

        var commentRenderedHandler = function(commentView, $container, commentModel) {
            var id = commentModel.get('id');
            var $likeContainer = $container.find('.comment-actions');

            var likeCommentView = new ConfluenceMobile.LikeCommentView({
                collection: new ConfluenceMobile.Likes(commentModel.get('likes'), {
                    contentId: id,
                    contextPath: ConfluenceMobile.AppData.get('confluence-context-path')
                }),
                currentUser: ConfluenceMobile.AppData.getObject('current-user')
            });

            $likeContainer.append(likeCommentView.render().el);
        };

        ConfluenceMobile.contentEventAggregator && ConfluenceMobile.contentEventAggregator.on('render:pre:after-content', contentRenderedHandler);
        ConfluenceMobile.contentEventAggregator && ConfluenceMobile.contentEventAggregator.on('render:comment-complete', commentRenderedHandler);
    };
});

require('confluence/module-exporter').safeRequire('confluence-like/event-handler', function(EventHandler) {
    'use strict';

    var $ = require('jquery');
    $(EventHandler);
});
