/**
 * @module confluence-like-mobile/like-collection
 */
define('confluence-like-mobile/like-collection', [
    'backbone',
    'underscore',
    'confluence-like-mobile/like-model'
], function(
    Backbone,
    _,
    LikeModel
) {
    'use strict';

    return Backbone.Collection.extend({
        model: LikeModel,
        url: function() {
            return this.contextPath + '/rest/likes/1.0/content/' + this.contentId + '/likes';
        },
        initialize: function(models, options) {
            options = options || {};

            if (options.contentId == undefined) {
                throw new Error('content ID is required.');
            }

            this.contentId = options.contentId;
            this.contextPath = options.contextPath || '';

            this.bind('add', function(model) {
                model.save();
            });
            this.bind('remove', function(model) {
                // This causes Backbone to *always* use a DELETE request.
                model.id = '';
                model.destroy();
            });
        },
        parse: function(results) {
            return _.map(results.likes, function(like) {
                return { username: like.user.name };
            });
        },
        addUser: function(name) {
            return this.add({ username: name });
        },
        removeUser: function(name) {
            return this.remove(this.getUserByName(name));
        },
        doesUserLikeThis: function(name) {
            return !!this.getUserByName(name);
        },
        getUserByName: function(name) {
            return this.find(function(like) {
                return like.get('username') == name;
            });
        }
    });
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-like-mobile/like-collection', 'ConfluenceMobile.Likes');
