/**
 * @module confluence-like-mobile/like-comment-view
 */
define('confluence-like-mobile/like-comment-view', [
    'confluence-like-mobile/like-view',
    'confluence/templates'
], function(
    LikeView,
    Templates
) {
    'use strict';

    return LikeView.extend({

        tagName: 'li',
        className: 'likes-container',

        getLikeSummary: function(existingLike, likesCount) {
            return Templates.Mobile.Likes.commentLikesSummary({ likesCount: likesCount });
        },

        /**
         * Extend the LikeView implementation to disable the like button if the comment has no id
         */
        render: function() {
            LikeView.prototype.render.call(this);

            var $likeButton = this.$el.find('button');
            if ($likeButton.length) {
                $likeButton[0].disabled = !this.collection.contentId;
            }

            return this;
        }
    });
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-like-mobile/like-comment-view', 'ConfluenceMobile.LikeCommentView');
