/**
 * @module confluence-like-mobile/like-view
 */
define('confluence-like-mobile/like-view', [
    'backbone',
    'confluence/templates',
    'jquery'
], function(
    Backbone,
    Templates,
    $
) {
    'use strict';

    return Backbone.View.extend({
        className: 'likes',

        events: {
            'click .like-button': 'likePage'
        },

        initialize: function(options) {
            this.collection.bind('change add remove reset', this.update, this);

            this.currentUsername = (options.currentUser || {}).userName || false;
        },

        // Overridden in sub objects.
        getLikeSummary: function(existingLike, likesCount) {
            // If you like this, then the other likes should be one less.
            if (existingLike) {
                likesCount--;
            }

            return Templates.Mobile.Likes.likesSummary({ youLike: existingLike, otherLikes: likesCount });
        },

        update: function() {
            var likesCount = this.collection.length;
            var existingLike = this.collection.doesUserLikeThis(this.currentUsername);

            this.$likeSummary.html(this.getLikeSummary(existingLike, likesCount));
            this.$likeButton.html(Templates.Mobile.Likes.likeButton({ youLike: existingLike }));
        },

        render: function() {
            var $item = $(Templates.Mobile.Likes.likes({ authenticated: this.currentUsername !== false }));
            this.$el.html($item);
            this.$likeButton = this.$('.like-button');
            this.$likeSummary = this.$('.like-summary');
            this.update();
            return this;
        },

        likePage: function(e) {
            e.preventDefault();
            if (this.collection.doesUserLikeThis(this.currentUsername)) {
                this.collection.removeUser(this.currentUsername);
            } else {
                this.collection.addUser(this.currentUsername);
            }

            // Uncomment when CONFDEV-29068 is resolved
            // ConfluenceMobile.Analytics.trackEvent("content", "click-like");
        }
    });
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-like-mobile/like-view', 'ConfluenceMobile.LikeView');
