/**
 * @module confluence-getting-started/getting-started
 */
define('confluence-getting-started/getting-started', [
    'jquery',
    'ajs',
    'confluence/legacy'
], function(
    $,
    AJS,
    Confluence
) {
    'use strict';

    return function() {
        function showWelcomeVideo($container) {
            $container.html(Confluence.Templates.GettingStarted.popularTabEmpty());

            var darken = function() {
                $('.gettingstarted .play').removeClass('light').addClass('dark');
            };
            var lighten = function() {
                $('.gettingstarted .play').removeClass('dark').addClass('light');
            };

            // Once we can replace viewing this video in fancy box, we can remove fancy box for good.
            $('.gettingstarted .movie-link')
                .hover(darken, lighten)
                .fancybox({
                    type: 'iframe',
                    width: 560,
                    height: 315,
                    padding: 0,
                    scrolling: 'no'
                });
        }

        // This event is fired by the Confluence Dashboard Macros plugin when the popular tab is otherwise empty
        AJS.bind('dashboard-recentupdates-popular.no-updates', function(event, data) {
            showWelcomeVideo(data.container);
        });
    };
});

require('confluence/module-exporter').safeRequire('confluence-getting-started/getting-started', function(GettingStarted) {
    'use strict';

    require('ajs').toInit(GettingStarted);
});
