require([
    'ajs',
    'jquery'
],
/**
 * @tainted WRM
 * @tainted Confluence.Templates.LicenseBanner
 */
function(
    AJS,
    $
) {
    "use strict";

    AJS.toInit(function () {
        var data = WRM.data.claim("com.atlassian.confluence.plugins.confluence-license-banner:confluence-license-banner-resources.license-details");

        if (!data) {
            AJS.warn("Unable to claim my required data");
            return;
        }

        var LicenseBanner = {
            destroyBanner: function () {
                $("#license-banner").slideUp(function () {
                    $("#license-banner").remove();
                });
            },

            remindMeLater: function () {
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    contentType: "application/json; charset=utf-8",
                    data : JSON.stringify({
                        atl_token : AJS.Meta.get('atl-token')
                    }),
                    url: AJS.contextPath() + "/rest/licensebanner/1.0/reminder/later"
                });

                LicenseBanner.destroyBanner();
            },

            remindMeNever: function () {
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    contentType: "application/json; charset=utf-8",
                    data : JSON.stringify({
                        atl_token : AJS.Meta.get('atl-token')
                    }),
                    url: AJS.contextPath() + "/rest/licensebanner/1.0/reminder/never"
                });

                LicenseBanner.destroyBanner();
            },

            createBanner: function (details) {
                var bannerHtml;
                if (details.showLicenseExpiryBanner) {
                    bannerHtml = Confluence.Templates.LicenseBanner.expiryBanner({
                        days: details.daysBeforeLicenseExpiry,
                        mac: details.renewUrl,
                        sales: details.salesUrl
                    });
                }
                else if (details.showMaintenanceExpiryBanner) {
                    bannerHtml = Confluence.Templates.LicenseBanner.maintenanceBanner({
                        days: details.daysBeforeMaintenanceExpiry,
                        mac: details.renewUrl,
                        sales: details.salesUrl
                    });
                }

                if (bannerHtml) {
                    var $banner = $(bannerHtml);
                    $("#full-height-container").prepend($banner);

                    $("#license-banner-later").click(function (e) {
                        e.preventDefault();
                        LicenseBanner.remindMeLater();
                    });
                    $("#license-banner-never").click(function (e) {
                        e.preventDefault();
                        LicenseBanner.remindMeNever();
                    });
                    $banner.find(".aui-message .aui-close-button").click(function (e) {
                        e.preventDefault();
                        LicenseBanner.remindMeLater();
                    });
                }
            }
        };

        LicenseBanner.createBanner(data);
    });
});
