// noinspection JSUnresolvedFunction
define('confluence-widget-connector/autoconvert-plugin-v4', [
    'tinymce',
    'confluence-editor/loader/tinymce-bootstrap',
    'confluence-widget-connector/autoconvert',
], function (TinyMce, BootstrapManager, WidgetAutoConvert) {
    'use strict';

    var WidgetConnectorEditorPlugin = function (ed) {
        ed.on('init', function () {
            // this command is defined in autoconvert-core which we are depending on
            ed.execCommand('addAutoconverter', false, WidgetAutoConvert.WidgetAutoConvertFn);
        });
    };

    TinyMce.PluginManager.add('widgetconnector', WidgetConnectorEditorPlugin);
    BootstrapManager.addTinyMcePluginInit(function (settings) {
        // tell tinymce to init this plugin when editor init
        settings.plugins += ',widgetconnector';
    });
});
try {
    require('confluence-widget-connector/autoconvert-plugin-v4');
} catch (e) {
    console.warn('Unable to load widget autoconvert', e);
}
