// noinspection JSUnresolvedFunction
define('confluence-widget-connector/autoconvert', ['tinymce'], function (TinyMce) {
    'use strict';

    var pasteRegularExpressions = [
        /open.spotify.com/,
        /facebook.com/,
        /linkedin.com\/embed/,
        /twitter.com/,
        /figma.com/,
        /prezi.com/,
        /microsoftstream.com/,
        /google([.a-z]+)\/(maps|calendar|presentation|document)/,
        /google([.a-z]+)\/spreadsheets(.*)(pubchart|pubhtml)/,
    ];

    var WidgetAutoConvert = function (uri, node, done) {
        var urlSource = decodeURI(uri.source);
        var expression = pasteRegularExpressions.find(function (expression) {
            return urlSource.match(expression);
        });

        if (expression) {
            var macro = { name: 'widget', params: { url: urlSource } };
            // noinspection JSUnresolvedVariable,JSUnresolvedFunction
            TinyMce.plugins.Autoconvert.convertMacroToDom(macro, done, done);
        } else {
            done();
        }
    };

    return { WidgetAutoConvertFn: WidgetAutoConvert };
});
