define('acm/app/models/data-supplier-collection', [
    'acm/app/ajs',
    'backbone',
    'eventbus'
],
function (
    AJS,
    Backbone,
    Eventbus
) {
    'use strict';

    return Backbone.Collection.extend (
        {
            initialize: function () {
                this.bind('error', function(model, error){
                    Eventbus.trigger('acm:monitoring-error', error);
                });
            },

            url: AJS.contextPath () + '/rest/atlassian-cluster-monitoring/cluster/suppliers'
        }
    );
});