define('acm/app/models/data-supplier-model', [
    'acm/app/ajs',
    'backbone',
    'eventbus'
],
function (
    AJS,
    Backbone,
    Eventbus
) {
    'use strict';

    var DataSupplierModel = Backbone.Model.extend(
        {
            initialize: function (options) {
                this.bind('error', function(model, error){
                    Eventbus.trigger('acm:monitoring-error', error);
                });

                this.pluginKey = options.pluginKey;
                this.moduleKey = options.moduleKey;
                this.nodeId = options.nodeId;
            },

            url: function () {
                return AJS.contextPath() +
                    '/rest/atlassian-cluster-monitoring/cluster/suppliers/data' +
                    '/' + this.pluginKey +
                    '/' + this.moduleKey +
                    '/' + encodeURIComponent(this.nodeId);
            }
        }
    );

    return DataSupplierModel;
});
