define('acm/app/views/bootstrap', [
    'exports',
    'wrm/require'
  ],
  function (
    exports,
    wrmRequire
  ) {
    'use strict';

    function getResourceInfo(clusteringAvailable, dcLicensed, clusterSetupEnabled) {
      if (clusteringAvailable) {
        return {
          key: 'wr!com.atlassian.cluster.monitoring.cluster-monitoring-plugin:clustering-resource',
          view: 'acm/app/views/clustering-view'
        };
      }
      if (!dcLicensed) {
        return {
          key: 'wr!com.atlassian.cluster.monitoring.cluster-monitoring-plugin:server-resource',
          view: 'acm/app/views/server-view'
        };
      }
      if (clusterSetupEnabled) {
        return {
          key: 'wr!com.atlassian.cluster.monitoring.cluster-monitoring-plugin:cluster-enabled-resource',
          view: 'acm/app/views/cluster-enabled-view'
        };
      }
      return {
        key: 'wr!com.atlassian.cluster.monitoring.cluster-monitoring-plugin:dc-licensed-resource',
        view: 'acm/app/views/dc-licensed-view'
      };
    }

    exports.init = function init(clusteringAvailable, dcLicensed, clusterSetupEnabled, major, minor) {
      var resource = getResourceInfo(clusteringAvailable, dcLicensed, clusterSetupEnabled);
      wrmRequire(resource.key).then(function() {
        require(resource.view).onReady(major, minor);
      });
    };
  });
