define('acm/app/views/cluster-enabled-view', [
    'acm/app/ajs',
    'backbone',
    'exports'
],
function (
    AJS,
    Backbone,
    exports
) {
    'use strict';

    exports.onReady = function onReady(major, minor) {
        AJS.trigger('analyticsEvent', {name: 'clusterEnabledView.rendered'});

        var ClusterEnabledView = Backbone.View.extend(
            {
                el: '#cluster-monitoring-data-container',
                template: Cluster.Monitoring.Templates.clusterEnabledTemplate,

                render: function () {this.$el.html(this.template({major: major, minor: minor}));}
            }
        );

        new ClusterEnabledView().render();
    };
});
