define('acm/app/views/clustering-view', [
    'acm/app/models/node-collection',
    'acm/app/models/data-supplier-model',
    'acm/app/views/node-collection-view',
    'acm/app/views/data-supplier-view',
    'acm/app/views/error-handling-view',
    'acm/app/ajs',
    'backbone',
    'jquery',
    'underscore',
    'exports'
],
function (
    NodeCollection,
    DataSupplierModel,
    NodeCollectionView,
    DataSupplierView,
    ErrorHandingView,
    AJS,
    Backbone,
    $,
    _,
    exports
) {
    'use strict';

    function getUrlParam(name) {
        var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
        if (results==null) {
            return null;
        }
        return decodeURI(results[1]) || 0;
    }

    function onReady() {
        AJS.trigger('analyticsEvent', {
            name: 'clusteringView.rendered',
            data: {origin: getUrlParam('origin')}
        });

        var AppRouter = Backbone.Router.extend(
            {
                errorHandingView: new ErrorHandingView(),
                nodeCollectionView: new NodeCollectionView(),
                supplierView: null,

                routes: {
                    '': 'home',
                    'providers/:pluginKey/:moduleKey/:nodeId': 'supplier'
                },

                home: function () {
                    this.nodeCollectionView.collection.fetch();
                },

                supplier: function (pluginKey, moduleKey, nodeId) {
                    var supplierModel = new DataSupplierModel({
                        pluginKey: pluginKey,
                        moduleKey: moduleKey,
                        nodeId: nodeId
                    });
                    if (this.supplierView) {
                        this.supplierView.closeView();
                    }
                    this.supplierView = new DataSupplierView({model: supplierModel});
                    this.supplierView.model.fetch();
                }
            }
        );

        var appRouter = new AppRouter();

        Backbone.history.start();
    }

    exports.onReady = onReady;
});
