define('acm/app/views/custom-node-attributes-decorator-view', [
    'acm/app/models/data-supplier-model',
    'backbone',
    'eventbus',
    'underscore'
],
function (
    DataSupplierModel,
    Backbone,
    Eventbus,
    _
) {
    'use strict';

    var CustomNodeAttributesDecoratorView = Backbone.View.extend(
        {
            statusTeplate: Cluster.Monitoring.Templates.lozenge,

            initialize: function () {
                this.listenTo(Eventbus, 'node-collection:rendered', this.render);
            },

            render: function (data) {
                var that = this;

                data.nodes.forEach(function (node) {
                    _.forEach(node.get('customNodeAttributes'), that.ensureColumnExists, {el:that.$el} );
                    var nodeId = node.get('nodeId');
                    var row = that.$el.find('[data-node-id="' + soy.$$escapeCssString(nodeId) + '"]');
                    _.forEach(node.get('customNodeAttributes'), that.decorateCustomNodeAttributes,
                        {row: row, template: that.statusTeplate} );
                });
            },

            ensureColumnExists: function (customNodeAttribute) {
                customNodeAttribute.escapedTitle = soy.$$escapeCssString(customNodeAttribute.title);

                //ref: https://stackoverflow.com/questions/7627000/javascript-convert-string-to-safe-class-name-for-css
                customNodeAttribute.cssSafeTitle = customNodeAttribute.title.replace(/[^a-z0-9]/g, function(s) {
                    var c = s.charCodeAt(0);
                    if (c == 32) return '-';
                    if (c >= 65 && c <= 90) return '_' + s.toLowerCase();
                    return '__' + ('000' + c.toString(16)).slice(-4);
                });

                // if a column does not exist for this customNodeAttribute already
                if ( ! AJS.$(this.el).find("#cluster-information-table th#" + customNodeAttribute.cssSafeTitle).length) {
                    // insert a new column, before the last (actions column is always the last)
                    AJS.$(this.el).find("#cluster-information-table thead tr").find("th:last")
                        .before('<th id="' + customNodeAttribute.cssSafeTitle + '" class="node_custom_attribute ' + customNodeAttribute.cssSafeTitle  +  '">'+ customNodeAttribute.escapedTitle +'</th>');
                    AJS.$(this.el).find("#cluster-information-table tbody tr").find("td:last")
                        .before('<td class="node_custom_attribute ' + customNodeAttribute.cssSafeTitle  + '" " headers="' + customNodeAttribute.cssSafeTitle + '" id="' + customNodeAttribute.cssSafeTitle + '"></td>');
                }
            },

            decorateCustomNodeAttributes: function(customNodeAttribute) {
                if (customNodeAttribute.style === 'NONE') {
                    this.row.find('.' + customNodeAttribute.cssSafeTitle).text(customNodeAttribute.value);
                } else {
                    var customNodeAttributeTemplate = this.template({
                        text: soy.$$escapeHtml(customNodeAttribute.value),
                        lozengeClassSuffix: customNodeAttribute.style.toLowerCase()
                    });
                    this.row.find('.' + customNodeAttribute.cssSafeTitle).html(customNodeAttributeTemplate);
                }
            },
        }
    );
    return CustomNodeAttributesDecoratorView;
});
