define('acm/app/views/dc-licensed-view', [
    'acm/app/ajs',
    'backbone',
    'exports',
    'jquery'
],
function (
    AJS,
    Backbone,
    exports,
    $
) {
    'use strict';

    function getUrlParam(name) {
        var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
        if (results==null) {
            return null;
        }
        return decodeURI(results[1]) || 0;
    };

    exports.onReady = function onReady(major, minor) {
        AJS.trigger('analyticsEvent', {
            name: 'dcLicensedView.rendered',
            data: {origin: getUrlParam('origin')}
        });

        var DCLicensedView = Backbone.View.extend(
            {
                el: '#cluster-monitoring-data-container',
                template: Cluster.Monitoring.Templates.dcLicensedTemplate,

                render: function () {
                    this.$el.html(this.template({major: major, minor: minor}));

                    $("#enable-clustering").click(function (e) {
                        e.preventDefault();
                        AJS.dialog2("#enable-clustering-dialog").show();
                    });

                    $("#confirm-cluster").click(function (e) {
                        AJS.trigger('analyticsEvent', {name: 'clusterModeEnable.clicked'});
                        e.preventDefault();
                        $.ajax({
                            url: AJS.contextPath() + '/rest/atlassian-cluster-monitoring/cluster/enable-clustering',
                            type: 'PUT',
                            success: function() {
                                window.location.reload();
                            },
                            error: function(xhr, error){
                                AJS.dialog2("#enable-clustering-dialog").hide();
                                var flagBody = "<p>This could be for a few reasons. Check your site is not in read-only mode, then try again.</p>"+
                                    "<a target='_blank' href=" + AJS.I18n.getText('help.cac.set.up.clustering.link', major, minor, AJS.I18n.getText('product.name')) +" >Learn more</a>";
                                AJS.flag({
                                    type: 'error',
                                    title: "We couldn't enable cluster mode",
                                    body: flagBody,
                                });
                            }
                        });
                        AJS.dialog2("#enable-clustering-dialog").hide();

                    });

                    $("#cancel-cluster").click(function (e) {
                        AJS.trigger('analyticsEvent', {name: 'clusterModeCancel.clicked'});
                        e.preventDefault();
                        AJS.dialog2("#enable-clustering-dialog").hide();

                    });},
            }
        );

        new DCLicensedView().render();
    };
});
