define('acm/app/views/error-handling-view', [
    'acm/app/ajs',
    'backbone',
    'eventbus'
],
function (
    AJS,
    Backbone,
    Eventbus
) {
    'use strict';

    var ErrorHandlingView = Backbone.View.extend(
        {
            el: '#cluster-monitoring-error-container',

            initialize: function () {
                this.listenTo(Eventbus, 'acm:monitoring-error', this.render);
            },

            render: function (error) {
                AJS.messages.warning('#cluster-monitoring-error-container', {
                    title: error.responseText,
                    closeable: true
                });
            }
        }
    );

    return ErrorHandlingView;
});
