define('acm/app/views/node-collection-view', [
    'acm/app/models/node-collection',
    'acm/app/views/data-supplier-dropdown-view',
    'acm/app/views/node-current-highlighter-view',
    'acm/app/views/runtime-info-supplier-view',
    'acm/app/views/custom-node-attributes-decorator-view',
    'backbone',
    'eventbus'
],
function (
    NodeCollection,
    DataSupplierDropDownView,
    NodeCurrentHighlighterView,
    RuntimeInfoSupplierView,
    CustomNodeAtributesDecoratorView,
    Backbone,
    Eventbus
) {
    'use strict';

    var NodeCollectionView = Backbone.View.extend(
        {
            el: '#cluster-monitoring-data-container',

            collection: new NodeCollection(),
            template: Cluster.Monitoring.Templates.clusteringInformation,

            initialize: function () {
                this.listenTo(this.collection, 'sync', this.render);
                this.currentClusterNodeView = new NodeCurrentHighlighterView({el: this.$el});
                this.clusterRuntimeTableView = new RuntimeInfoSupplierView({el: this.$el});
                this.clusterDataProviderTableView = new DataSupplierDropDownView({el: this.$el});
                this.customNodeAttributesDecoratorView = new CustomNodeAtributesDecoratorView({el: this.$el});
            },

            render: function () {
                this.$el.html(this.template({nodes: this.collection.toJSON()}));

                Eventbus.trigger('node-collection:rendered', {nodes: this.collection});
            }
        }
    );

    return NodeCollectionView;
});