define('acm/app/views/node-current-highlighter-view', [
    'acm/app/models/node-current-model',
    'acm/app/ajs',
    'backbone',
    'eventbus'
],
function (
    NodeCurrentModel,
    AJS,
    Backbone,
    Eventbus
) {
    'use strict';

    var NodeCurrentHighlighterView = Backbone.View.extend(
        {
            model: new NodeCurrentModel(),

            initialize: function () {
                this.listenTo(Eventbus, 'node-collection:rendered', this.fetchModel);
                this.listenTo(this.model, 'sync', this.render);
            },

            fetchModel: function (data) {
                this.model.fetch();
            },

            render: function () {
                var currentNodeRow = this.$el.find('[data-node-id="' + soy.$$escapeCssString(this.model.get('nodeId')) + '"]');
                currentNodeRow.addClass('node-current-row');

                // mark the current row so current node indicator is visible
                var currentNodeSpan = currentNodeRow.find('.node-current');
                currentNodeSpan.addClass('selected');

                // add tooltip to current node indicator
                var currentNodeIndicatorElement = currentNodeSpan.find("#node-current-indicator");
                currentNodeIndicatorElement.attr('title', AJS.I18n.getText('cluster-monitoring.overview.currentnode.tooltip'));
                currentNodeIndicatorElement.tooltip();
            }
        }
    );

    return NodeCurrentHighlighterView;
});

