define('acm/app/views/server-view', [
    'acm/app/ajs',
    'backbone',
    'exports'
],
function (
    AJS,
    Backbone,
    exports
) {
    'use strict';

    exports.onReady = function onReady() {
        AJS.trigger('analyticsEvent', {name: 'serverView.rendered'});

        var ServerView = Backbone.View.extend(
            {
                el: '#cluster-monitoring-data-container',
                template: Cluster.Monitoring.Templates.serverTemplate,

                render: function () {this.$el.html(this.template());}
            }
        );

        new ServerView().render();
    };
});
