window.atstPage = (moduleId) => {
  const pageScripts = {
    "create-support-request/view": window.loadCreateSupportRequestStart,
    "create-support-request/execute": () => {
      const v = (data) => AJS.$("#create-support-request-execute").data(data);
      setTimeout(() => {
        window.pollForProgress(
          `${v("base-url")}/rest/troubleshooting/latest/support-request/${v("task-id")}`,
          "stp-request",
          1,
        );
      }, 500);
      AJS.$("#start-again-link").on("click", (e) => {
        e.preventDefault();
        AJS.$("#stp-request-start-again").submit();
      });
    },
    "atst-detect-issues/view": () => {
      window.require(["troubleshooting/detect-issues/main"], (DetectIssues) =>
        DetectIssues.initInstanceHealth(),
      );
    },
    "hercules/view": () => {
      const v = (data) => AJS.$("#hercules-view").data(data);
      if (v("scan-results-size") > 0) {
        window.loadHerculesResultTable();
        let scanDate = v("scan-date");
        if (scanDate) {
          if (scanDate.indexOf("Just now") > -1) {
            scanDate = scanDate.toLowerCase();
          }
          const $dateElem = `<div id="scan-cache-date">Results were refreshed ${scanDate}</div>`;
          const $refreshScanIcon = AJS.$("#refresh-scan-result");
          $refreshScanIcon.after($dateElem);
        }
      } else {
        // If this script is executed, it means that we're back to the default log scan start page,
        // and we don't need the refresh button here
        AJS.$("#refresh-scan-result").remove();
        window.herculesToggleLogOptions();
        AJS.$("#logFilePath").data("logFilePath", "");
        AJS.$("#hercules").data("servletHomePath", v("servlet-home-path"));
        window.initLogAnalyzerControlPanel(false);
      }
      AJS.$("#herculesLogToggle").on("change", () => {
        window.herculesToggleLogOptions();
      });
    },
    "hercules/execute": () => {
      const v = (data) => AJS.$("#hercules-execute").data(data);
      if (v("scan-results-size") > 0) {
        window.loadHerculesResultTable();
      } else {
        window.initLogAnalyzerControlPanel(false);
        AJS.$("#hercules").data("servletHomePath", v("servlet-home-path"));
        AJS.$("#hercules").data(
          "statusUrl",
          `${v("base-url")}/rest/troubleshooting/latest/hercules/scans/${v("scan-id")}`,
        );
        AJS.$("#hercules").data("scanId", v("scan-id"));
        AJS.$("#hercules").data("startTime", v("start-time"));
        window.refreshPercentComplete(1);
        AJS.$('[name="scan-cancel"]').on("click", () => {
          AJS.trigger("analyticsEvent", {
            name: "stp.log.analyzer.run.cancel",
          });
        });
      }
    },
    "support-zip/execute": () => {
      const v = (data) => AJS.$("#support-zip-execute").data(data);
      window.setupSupportZipCreationPolling(v("base-url"), v("task-id"));
    },
    "system-info/view": () => {
      function escape(str) {
        return str
          ? str.replace(/([ #;&,.+*~':"!^$[\]()=>|/@])/g, "\\$1")
          : str;
      }
      function toggleContent() {
        const id = AJS.$(this).attr("id");
        AJS.$(`#content-${escape(id)}`).toggle();
        AJS.$(this).toggleClass("expanded");
      }
      AJS.$(".stp-propertystore > .stp-collapsible").bind(
        "click",
        toggleContent,
      );
    },
  };
  if (pageScripts[moduleId]) {
    pageScripts[moduleId]();
  }
};
