function atstGetContainer(moduleId) {
  // Need to be defensive about detect-issues as it may not load.
  var $container = AJS.$("#" + moduleId + ".troubleshooting-module"),
    $mainContainer = AJS.$("#" + atstDefaultTab() + ".troubleshooting-module");
  if ($container.length > 0) {
    return $container.first();
  } else if ($mainContainer.length > 0) {
    return $mainContainer.first();
  }
  throw "No container for module " + moduleId;
}

// A function to submit a form's data and update a container with the results
// This function should only be bounce to the submit method of a form
function atstSubmitFormViaAjax(event) {
  // "this" = the submit button contained in the form we care about
  event.preventDefault();

  var moduleId = AJS.$(this).closest(".troubleshooting-module").attr("id");

  if (moduleId != null) {
    var $form = AJS.$("#" + moduleId + " form.aui");
    var formData = $form.serialize();
    var formAction = $form.attr("action");

    var $container = atstGetContainer(moduleId);
    $container.data("oldContent", $container.html());
    $container.html("");
    $container.addClass("loading");
    $container.removeClass("loaded");

    AJS.$.ajax({
      async: "true",
      // This has to be quite high to allow mail timeouts to function correctly.
      timeout: 325000,
      cacheBoolean: "false",
      data: formData,
      dataType: "html",
      error: function (XMLHttpRequest, textStatus, errorThrown) {
        atstDisplayAjaxError(moduleId, XMLHttpRequest, textStatus, errorThrown);
      },
      success: function (data, textStatus, XMLHttpRequest) {
        atstDisplayAjaxResults(moduleId, data);
      },
      type: "POST",
      headers: {
        "X-Atlassian-Token": "no-check",
      },
      url: formAction,
    });
  } else {
    AJS.log("Undefined moduleId");
  }
}

// when someone clicks a placeholder link to switch to another module, expand the module and contract any others
function atstExpandHighlightedModule(event) {
  var moduleHandle = AJS.$(this).attr("href");
  AJS.$("li.menu-item a[href='" + moduleHandle + "']").click();
}

// A function to convert a link into an AJAX call.  Should be bound to a link.
function atstLoadLinkViaAjax(event) {
  event.preventDefault();

  // "this" = the link we're bound to
  var moduleId = AJS.$(this).parents(".troubleshooting-module").attr("id");

  if (moduleId != null) {
    atstGetPageViaAjax(moduleId, AJS.$(this).attr("href"));
  }
}

function atstAjaxLoad(moduleId, URL) {
  var $container = atstGetContainer(moduleId);

  AJS.$.ajax({
    async: "true",
    cacheBoolean: "false",
    dataType: "html",
    success: function (data, textStatus, XMLHttpRequest) {
      $container.html(data);
      window.atstPage(URL.replace(/.*\/(?=[a-z-]+\/[a-z-]+)/, ""));
      atstConvertLinksAndForms($container);
      $container.addClass("loaded");
      $container.removeClass("loading");
      AJS.trigger("troubleshootingTabLoaded#" + moduleId);
    },
    // This has to be quite high to allow mail timeouts to function correctly.
    timeout: 325000,
    type: "GET",
    url: URL,
  });
}

function atstGetPageViaAjax(moduleId, URL) {
  var container = atstGetContainer(moduleId);

  container.data("oldContent", container.html());

  container.html("");
  container.addClass("loading");
  container.removeClass("loaded");

  AJS.$.ajax({
    async: "true",
    cacheBoolean: "false",
    dataType: "html",
    error: function (XMLHttpRequest, textStatus, errorThrown) {
      atstDisplayAjaxError(moduleId, XMLHttpRequest, textStatus, errorThrown);
    },
    success: function (data, textStatus, XMLHttpRequest) {
      atstDisplayAjaxResults(moduleId, data);
    },
    // This has to be quite high to allow mail timeouts to function correctly.
    timeout: 325000,
    type: "GET",
    url: URL,
  });
}

function atstDisplayAjaxResults(moduleId, data) {
  // the container we'll put our results into
  var container = atstGetContainer(moduleId);

  container.html(data);

  window.atstPage(`${moduleId}/execute`);

  // We need to bind the usual functions to the new content
  atstConvertLinksAndForms(container);
  container.addClass("loaded");
  container.removeClass("loading");

  AJS.trigger("troubleshootingTabUpdated#" + moduleId);
}

function atstDisplayAjaxError(
  moduleId,
  XMLHttpRequest,
  textStatus,
  errorThrown,
) {
  // the container we'll put our results into
  var container = atstGetContainer(moduleId);

  var errorContent;
  if (XMLHttpRequest.status == 403) {
    errorContent =
      '<p class="title">Error loading content, please reload, log in as an administrator, and try again.</p>';
  } else if (errorThrown.match(/timeout/)) {
    errorContent =
      '<p class="title">Your request timed out.  Please try again.  If you\'re sending a support request, please check your mail settings.</p>';
  } else {
    errorContent =
      '<p class="title">Error retrieving results:</p><p>' +
      errorThrown +
      "</p>";
  }

  // prepend the error to the previous page so that we at least have our original content
  var prettyError =
    '<div class="aui-message aui-message-error">' + errorContent + "</div> ";

  container.html(prettyError + container.data("oldContent"));

  // Bind the usual functions to the new content
  atstConvertLinksAndForms(container);
  container.addClass("loaded");
  container.removeClass("loading");
}

function atstConvertLinksAndForms(domObject) {
  domObject.find(".module-ajax-link").click(atstLoadLinkViaAjax);
  domObject.find("form.aui").submit(atstSubmitFormViaAjax);
  domObject
    .find("a.troubleshooting-module-link")
    .click(atstExpandHighlightedModule);
}

function atstDefaultTab($) {
  // Only select detect-issues if it exists:
  if (AJS.$("#atst-detect-issues").length) {
    return "atst-detect-issues";
  } else {
    return "hercules";
  }
}

AJS.$(function ($) {
  var servletHomePath = $("#tabs-troubleshooting").data("servlet-home-path");
  if (!servletHomePath) {
    AJS.messages.error({
      title: AJS.I18n.getText("stp.tabs.failed"),
      body: AJS.I18n.getText("stp.tabs.failed.details.path"),
    });
    return;
  }
  // As we're slowly implementing React tab-by-tab, tabs.vm already has the dumb web-component for zips so we don't load it.
  $("#tabs-troubleshooting .tabs-pane")
    .not("#support-zip")
    .not("#diagnostic")
    .not("#instance-health-score")
    .each(function () {
      atstAjaxLoad(this.id, servletHomePath + "/" + this.id + "/view");
    });

  // Bind "our" links to an AJAX function that retrieves their data
  atstConvertLinksAndForms(AJS.$(document));

  var $tabs,
    $tabMenu,
    REGEX = /#.*/,
    ACTIVE_TAB = "active-tab",
    ACTIVE_PANE = "active-pane";

  // Remove after AUI has been updated to use this change method.
  AJS.tabs.change = function ($a, e) {
    var $pane = AJS.$($a.attr("href").match(REGEX)[0]);

    $pane.addClass(ACTIVE_PANE).siblings().removeClass(ACTIVE_PANE);
    $a.closest("ul.tabs-menu").find(".menu-item").removeClass(ACTIVE_TAB);
    $a.parent("li.menu-item").addClass(ACTIVE_TAB);

    $a.trigger("tabSelect", {
      tab: $a,
      pane: $pane,
    });

    atstTabSelectEvent($a.data("title"));
  };

  if (atstVisitThroughNotification()) {
    AJS.trigger("analyticsEvent", { name: "stp.page.opened.via.menu" });
  }

  var urlHash = window.location.hash;
  var validUrlHashes = [
    "#atst-detect-issues", // Instance Health tab
    "#hercules", // Log Analyzer tab
    "#create-support-request", // Get Help tab
    "#support-zip", // Support Zip tab
    "#diagnostic", // Diagnostic tab
    "#instance-health-score", // Instance Health Score tab
    "#system-info",
  ]; // System Info tab, applicable for Stash and BB Server

  if (urlHash && validUrlHashes.indexOf(urlHash) > -1) {
    AJS.tabs.change(jQuery('a[href="' + urlHash + '"]'));
  } else {
    // If there's no URL hash or invalid one specified, always open the default tab instead
    AJS.tabs.change(jQuery('a[href="#' + atstDefaultTab() + '"]'));
  }
});

function atstTabSelectEvent(action) {
  action = action.replace(".title", ".clicked");
  AJS.trigger("analyticsEvent", { name: action });

  return false;
}

function atstVisitThroughNotification() {
  return window.location.search.indexOf("source=notification") > -1;
}
