AJS.toInit(function($) {
    var currentImg,
        effectSrcRegEx = /(\?|\&)(effects\=[^&]+)($|&)/,
        effectAttrRegEx = /(^|\&)(effects\=([^&]+))($|&)/,
        lastEffect = null,
        previews = [],
        dimMax = 4000; // we won't apply effects to images larger than 4000 x 4000

    preparePreviews();
    if (Confluence.Editor.ImageProps) {
        createImageEffectsPanel();
    } else {
        createImageEffectsDialog();
    }

    function createImageEffectsPanel() {
        AJS.bind('dialog-created.image-properties', function(event, data) {
            currentImg = data.img;
            var linkId = 'image-effects',
                panelClass = 'image-effects-panel';
            if (!handlesImageType()) {
                Confluence.Editor.ImageProps.registerPanel(linkId, getPanelContent(AJS.I18n.getText('image.effects.error.externalimage')), panelClass, null)
            } else if (!handlesImageSize()) {
                Confluence.Editor.ImageProps.registerPanel(linkId, getPanelContent(AJS.I18n.getText('image.effects.error.pixels.toobig')), panelClass, null);
            } else {
                Confluence.Editor.ImageProps.registerPanel('image-effects', getPanelContent(), 'image-effects-panel', saveFnForPanel);
            }
        });
        AJS.bind('dialog-before-show.image-properties', function() {
            populatePanelContents();
            setEffectSelection(getEffect($(currentImg)));
        });
    }

    function createImageEffectsDialog() {
        var effectsDialog = new AJS.Dialog({width: 600, height: 500, id:'image-effects-dialog'});
        effectsDialog.addHeader(AJS.I18n.getText('image.effects.dialog.title'));
        effectsDialog.addPanel('', getPanelContent(), '');
        populatePanelContents();
        effectsDialog.addSubmit(AJS.I18n.getText('image.effects.submit'), function() {
            var promise = saveFnForDialog();
            promise.done(function() {
                effectsDialog.hide();
            });
        });
        effectsDialog.addCancel(AJS.I18n.getText('image.effects.close'), function() {
            effectsDialog.hide();
        });

        AJS.Confluence.PropertyPanel.Image.pluginButtons.push(null, {create: function($img) {
            currentImg = $img[0];
            var effect = getEffect($img),
                disabled = !handlesImageType();
            return {
                className: 'image-effects',
                text: AJS.I18n.getText('image.effects.button.text'),
                tooltip: disabled ? AJS.I18n.getText('image.effects.error.externalimage') : AJS.I18n.getText('image.effects.button.tooltip'),
                click: function() {
                    if (!handlesImageSize()) {
                        alert(AJS.I18n.getText("image.effects.error.pixels.toobig"));
                        return false;
                    }
                    setEffectSelection(getEffect($(currentImg)));
                    AJS.Confluence.PropertyPanel.destroy();
                    effectsDialog.show();
                },
                disabled: disabled,
                selected: !!effect
            };
        }});
    }

    function setEffect($img, effects) {
        var src = $img.attr('src');
        var match = effectSrcRegEx.exec(src);
        var effectStr = effects ? 'effects=' + effects : '';
        if (match) {
            src = src.replace(match[2], effectStr);
        }
        else if (effects) {
            src = src + (src.indexOf('?') != -1 ? '&' : '?') + effectStr;
        }

        $img.attr('src', src);
        $img.attr('data-mce-src', src);

        var queryParams = $img.attr('confluence-query-params');
        if (queryParams){
            var match = effectAttrRegEx.exec(queryParams);
            if (match) {
                queryParams = queryParams.replace(match[2], effectStr);
            }
            else {
                queryParams = queryParams + '&' + effectStr;
            }
        }
        else {
            queryParams=effectStr;
        }
        $img.attr('confluence-query-params', queryParams);
    }

    function getEffect($img) {
        var queryParams = $img.attr('confluence-query-params');
        var match = effectAttrRegEx.exec(queryParams);
        if (match) {
            return match[3];
        }
    }

    function setEffectSelection(effect) {
        $('.image-effect-preview.selected').removeClass('selected');
        if (effect) {
            $(previews).each(function(i, preview) {
                if (preview.effects == effect) {
                    $($('.image-effect-preview')[i]).addClass('selected');
                    return false;
                }
            });
        } else {
            $('.image-effect-preview.image-effect-none').addClass('selected');
        }
        lastEffect = effect;
    }

    function preparePreviews() {
        previews.push({name: AJS.I18n.getText('image.effects.none'), effects: null});
        previews.push({name: AJS.I18n.getText('image.effects.taped'), effects: 'border-simple,blur-border,tape'});
        previews.push({name: AJS.I18n.getText('image.effects.instant'), effects: 'border-polaroid,blur-border'});
        previews.push({name: AJS.I18n.getText('image.effects.curlshadow'), effects: 'border-simple,shadow-kn'});
        previews.push({name: AJS.I18n.getText('image.effects.snapshot'), effects: 'border-simple,blur-border'});
        previews.push({name: AJS.I18n.getText('image.effects.dropshadow'), effects: 'drop-shadow'});
    }

    function getPanelContent(error) {
        if (error) {
            return '<div class="aui-message aui-message-warning warning"><span class="aui-icon icon-warning"></span>' + error + '</div>';
        }
        return '<div class="image-effects"><ul class="image-list"></ul></div>';
    }

    function populatePanelContents() {
        var $list = $('div.image-effects ul.image-list');
        var randomIdx = Math.floor(Math.random()*22) + 1;
        for (var i = 0; i < previews.length; i++) {
            var $item = $('<li class="attached-image image-effect-preview' + (!previews[i].effects ? ' image-effect-none' :'') + '">' +
                    '<div class="image-container">' +
                        '<img class="thumbnail" src="' + AJS.contextPath() + '/plugins/servlet/imgFilter.png?preview=true&id=' + randomIdx + '&effects=' + previews[i].effects + '" title="' + previews[i].name + '" style="margin-top: 5px">' +
                    '</div>' +
                    '<span class="caption filename" title="' + previews[i].name + '">' + previews[i].name + '</span>' +
                '</li>');

            $item.hover(function(){
                $(this).addClass('hover');
            },
            function(){
                $(this).removeClass('hover');
            });

            $list.append($item);

            var preview = previews[i];
            $item.click(preview, function(e) {
                $('.image-effect-preview.selected').removeClass('selected');
                $(this).addClass('selected');
                lastEffect = e.data.effects;
            });
        }
    }

    function handlesImageType() {
        return !$(currentImg).hasClass('confluence-external-resource');
    }

    function handlesImageSize() {
        return !(currentImg.naturalHeight && currentImg.naturalWidth && (currentImg.naturalHeight * currentImg.naturalWidth) > (dimMax * dimMax));
    }

    function saveFnForPanel() {
        return saveFn();
    }

    function saveFnForDialog() {
        return saveFn(showSpinner, hideSpinner);
    }

    function saveFn(showSpinner, hideSpinner) {
        var deferred = $.Deferred();

        showSpinner && showSpinner();
        currentImg.onload = imageReadyCallback;

        var oldSrc = currentImg.src;
        setEffect($(currentImg), lastEffect);
        if (currentImg.src == oldSrc) {
            imageReadyCallback();
        }

        function imageReadyCallback() {
            hideSpinner && hideSpinner();
            deferred.resolve();
            currentImg.onload = null;
            tinyMCE.activeEditor.undoManager.add();
        }

        return deferred;
    }

    function showSpinner() {
        var $dialog = dialog.popup.element,
            radius = 50,
            lineThickness = radius * 13 / 60,
            innerRadius = radius * 30 / 60,
            lineLength = radius - innerRadius,
            $blanket = $('<div class="image-properties-loading-blanket"><div class="loading-data"></div></div>').appendTo($dialog.find('.dialog-page-body')),
            $spinner = $blanket.find('.loading-data');

        $blanket.css({width: $blanket.parent().width(), height: $dialog.height()});
        $spinner.css({marginTop: -radius * 1.2, marginLeft: -radius * 1.2});


        var opts = {
            color: 'var(--ds-text, #666)',
            width: lineThickness,
            radius: innerRadius,
            length: lineLength,
            top: 0,
            left: 0,
            zIndex: 0,
            speed: 1.042
        };

        $spinner.spin(opts);
    }

    function hideSpinner() {
        var $spinner = dialog.popup.element.find('.image-properties-loading-blanket .loading-data');

        $spinner.css({marginTop: '', marginLeft: ''});
        $spinner.spinStop();
        $spinner.closest('.image-properties-loading-blanket').remove();
    }
});