$(function($){
    $.ajaxSettings.timeout = 10e3;

    /**
     * Low level method for displaying a mobile head attached modal.
     * @param options
     */
    ConfluenceMobile._buildModal = function(options) {

        var defaults = {
            message: "",
            buttons: []
        };

        options = _.extend(defaults, options);

        var $modal = $(Confluence.Templates.Mobile.App.modalDialog({
            message: options.message,
            buttons: options.buttons
        }));

        $modal.find("button").click(function () {
           var index = $(this).attr("data-index");
           var event = options.buttons[index].event;
           if (event) {
               event.call(this, controls);
           }
        });

        $("body").append($modal);

        var controls = {
            show: function() {
                ConfluenceMobile.dim();
                $modal.show();
            },

            hide: function() {
                ConfluenceMobile.undim();
                $modal.hide();
            },

            destroy: function() {
                controls.hide();
                $modal.remove();
            },

            $el: $modal
        };

        return controls;
    };

    /**
     * A generic handler that can be used to handle an AJAX error if you have no
     * specific handling you want to apply.
     *
     * The default behaviour is to cause a load of the login screen on a 401 error, and to
     * display a dialog for any other error status code.
     *
     * @param resp the response from the call
     * @param model the model object that failed to update
     * @param options an optional object containing the fields 'message', 'onRetry' and 'onCancel'. message
     * is the localised message to be displayed. onRetry is the function that should be run if the user chooses to retry
     * the failed operation. If not supplied then the user will not be presented with a retry option. onCancel is the function
     * to be run when the user cancels. If not supplied then the dialog will simply dismiss.
     */
    ConfluenceMobile.genericAjaxErrorHandler = function(resp, model, options) {
        if (resp.status == 401) {
            ConfluenceMobile.loadLoginScreen(true);
            // the app is replaced at this point
            return;
        }

        if (resp.status == 0) {
            title = AJS.I18n.getText("confluence.mobile.loading.timeout");
        }

        if (!options) {
            options = {};
        }

        if (!options.message) {
            options.message = AJS.I18n.getText("confluence.mobile.operation.failed");
        }

        var buttons = [
            {
                type: "",
                text: "Cancel",
                event: options.onCancel
            }
        ];

        if (options.onRetry) {
            buttons.unshift({
                type: "primary",
                text: options.retryButtonLabelText || AJS.I18n.getText("confluence.mobile.retry"),
                event: options.onRetry
            });
        }

        var modal = ConfluenceMobile._buildModal({
            message: options.message,
            buttons: buttons
        });

        modal.show();

        var errorDialogCleanUp = function(e) {
            modal.hide();
            return false;
        };

        modal.$el.on("click", ".button", errorDialogCleanUp);
        $(window).one("hashchange", errorDialogCleanUp);
    };

    /**
     * Cause the app to be replaced by the login screen with the request parameters set such that
     * the current screen will load again after successful login.
     *
     * @param forCurrentUser if true then pre-populate the login screen with the username of the current user.
     */
    ConfluenceMobile.loadLoginScreen = function(forCurrentUser) {
        var contextPathRegex = new RegExp("^" + ConfluenceMobile.AppData.get("confluence-context-path"));
        // strip context from url
        var originalUri = window.location.pathname.replace(contextPathRegex, '');
        // strip leading '?' from search to handle cross browser inconsistency
        var originalUrl = originalUri + "?" + window.location.search.replace(/^\?/,"") + window.location.hash;

        var currentUser = ConfluenceMobile.AppData.getObject("current-user");

        var loginUrl = ConfluenceMobile.AppData.get("confluence-context-path") + "/login.action?os_destination=" + encodeURIComponent(originalUrl);
        if (forCurrentUser && currentUser && !currentUser.anonymousUser) {
            loginUrl = loginUrl + "&os_username=" + currentUser.userName;
        }

        // stripping ':' from protocol to handle cross browser inconsistency
        var baseUrl = window.location.protocol.replace(/:$/,"") + "://" + window.location.host;
        window.location.href = baseUrl + loginUrl;
    };

    /**
     * Covers screen with semi-transparent DIV. This is largely copied from AUI.
     */
    ConfluenceMobile.dim = function () {
        if (!ConfluenceMobile.dim.$dim) {
            ConfluenceMobile.dim.$dim = $("<div class=\"blanket\"></div>");
            $("body").append(ConfluenceMobile.dim.$dim);

            ConfluenceMobile.dim.cachedOverflow = $("body").css("overflow");
            $("body").css("overflow", "hidden");
        }
    };

    /**
     * Removes semi-transparent DIV
     */
    ConfluenceMobile.undim = function() {
        if (ConfluenceMobile.dim.$dim) {
            ConfluenceMobile.dim.$dim.remove();
            ConfluenceMobile.dim.$dim = null;

            $("body").css("overflow",  ConfluenceMobile.dim.cachedOverflow);
        }
    };
});
