ConfluenceMobile.AppBanner = Backbone.Model.extend({

   IOS_APP_STORE_URL: "https://itunes.apple.com/app/apple-store/id1288365159?pt=696495&ct=wac_1&mt=8",
   ANDROID_PLAY_STORE_URL: "market://details?id=com.atlassian.confluence.server",

   initialize: function () {
      var content = this.get('content');
      var pageId = content && content.contentId;
      var commentId = content && content.commentId;
      this.mobileSchemeUrl = this.getMobileSchemeURL(pageId, commentId);
   },

   isIos: function() {
      return ConfluenceMobile.AppData.get("os") === 'ios';
   },

   getMobileSchemeURL: function(pageId, commentId) {
      var baseUrl = ConfluenceMobile.AppData.get("confluence-base-url");
      var schemeUrl = baseUrl.replace(/http:|https:/, "confluence-server:") + "/pages/viewpage.action?";
      schemeUrl += "pageId=" + pageId;

      if (commentId) {
         schemeUrl += "&focusedCommentId=" + commentId;
      }
      return schemeUrl;
   },

   getAppStoreUrl: function() {
      return this.isIos() ? this.IOS_APP_STORE_URL : this.ANDROID_PLAY_STORE_URL;
   },

   openApp: function() {
      var $this = this;
      window.location = this.mobileSchemeUrl;

      // This is a temporary solution to avoid an issue with iOS 12.4 and above where
      // Safari treats the app store as a trusted app and does not alert the user before delegation.
      if (!this.isIos()) {
         window.setTimeout(function () {
            window.location = $this.getAppStoreUrl();
         }, 200);
      }
   }
});