/**
 * Apply some simply parsing to a plain text comment to pretty it up a little
 * for HTML.
 *
 * @text the text content of a comment including new lines
 * @mentionMarkup an array containing markup to substitute for mentions text. The comment creation REST resource
 *     only understands editor HTML format, so mentions need to be in the HTML format.
 *     mentionMarkup = [{
 *         mentionString: '[@Ted Piotrowski]',
 *         html: '<a class="confluence-userlink user-mention" data-username="...>...</a>'
 *     }]
 */
ConfluenceMobile.textToHtml = function(text, mentionMarkup) {
    var commentHtml =  "<p>" +
        _.map(text.trim().split("\n\n"), function(paragraph) {
            paragraph = ConfluenceMobile.htmlEncode(paragraph);
            return paragraph.replace(/\n/g, "<br/>");
        })
            .join("</p><p>") +
        "</p>\n";

    if (mentionMarkup) {
        for (var i = 0; i < mentionMarkup.length; i++) {
            commentHtml = commentHtml.replace(mentionMarkup[i].mentionString, mentionMarkup[i].html);
        }
    }
    return commentHtml;
};

/**
 * Replace the image placeholders inserted via upload with html of the image source as we are not really converting wiki text
 */
ConfluenceMobile.includeImages = function(text) {
    var pageId = $("#inner-container").find(".content").data("content-id");
    var baseUrl = ConfluenceMobile.AppData.get("confluence-context-path");
    var commentHtml = text;
    var images = text.match(/!\w+\.(png|jpg|jpeg|gif)!/gi) || [];
    for (var i=0; i < images.length; i++) {
        var fileName = images[i].replace(/!/g, '');
        var imageHtml = Confluence.Templates.Mobile.PhotoUpload.confluenceCommentData({
            pageId: pageId,
            fileName: fileName,
            baseUrl: baseUrl
        });
        commentHtml = commentHtml.replace(images[i], imageHtml);
    }
    return commentHtml;
};
