/**
 * View for content watch button.
 *
 */
define('confluence-mobile/watch-view',
    [
        'backbone',
        'underscore'
    ],
    function (Backbone, _) {
        return Backbone.View.extend({
            events: {
                'click button': 'toggleWatch'
            },

            initialize: function () {
                _.bindAll(this, 'render', 'update', 'toggleWatch');
                this.model.on('change:watching', this.update, this);
            },

            render: function () {
                return this;
            },

            update: function (model, watching) {
                this.$('button').toggleClass('pressed');
                this.$('span').toggleClass('watching');
            },

            toggleWatch: function () {
                this.model.toggleWatch();
            }
        });
    });
