ConfluenceMobile.PhotoUploadDialog = Backbone.View.extend({

    className: "photo-dialog",

    events: {
        "click .close-button": "userCloseDialog"
    },
    initialize: function(options) {
        this.blanket = options.blanket;
        this.uploader = options.uploader;
        this.handleDialogClose = options.handleDialogClose;
        ConfluenceMobile.photoUploaderEventAggregator.unbind("close-photoupload-dialog");
        ConfluenceMobile.photoUploaderEventAggregator.unbind("show-dialog-progressbar");
        ConfluenceMobile.photoUploaderEventAggregator.bind("close-photoupload-dialog", this.closeDialog, this);
        ConfluenceMobile.photoUploaderEventAggregator.bind("show-dialog-progressbar", this.showProgressBar, this);
        this.render();
        // if user navigates back, close the uploader modal
        ConfluenceMobile.routerEventAggregator.bind("change", this.closeDialog, this);
    },

    render: function(){
        this.$el.html(Confluence.Templates.Mobile.PhotoUpload.mainDialog());
        this.blanket.$el.html(this.$el);
        this.$el.css('top', window.pageYOffset);
        return this;
    },

    userCloseDialog: function(){
        this.uploader && this.uploader.unbind('FileUploaded');
        this.handleDialogClose && this.handleDialogClose();
        ConfluenceMobile.Analytics.trackEvent('mobile-photo-upload', 'close-dialog');
        this.closeDialog();
    },

    closeDialog: function(){
        ConfluenceMobile.photoUploaderEventAggregator.unbind("update-dialog-progressbar");
        this.blanket.remove();
        ConfluenceMobile.routerEventAggregator.unbind("change", this.closeDialog);
        this.remove();
    },

    showProgressBar: function(files){
        ConfluenceMobile.photoUploaderEventAggregator.bind("update-dialog-progressbar", this.updateProgressBar, this);
        this.$el.find(".photo-dialog-content").html(Confluence.Templates.Mobile.PhotoUpload.progressBar({
            files: files
        }));
        ConfluenceMobile.Analytics.trackEvent('mobile-photo-upload', 'show-progress-bar');
    },

    updateProgressBar: function(file){
        var progressBar = this.$el.find("#file-" + file.id + "-progress");
        progressBar.attr("aria-valuenow", file.percent);
        progressBar.find(".ui-progressbar-value").css({width:file.percent+"%"});
        var loadedNiceSize = AJS.DragAndDropUtils.niceSize(file.loaded);
        var totalNiceSize = AJS.DragAndDropUtils.niceSize(file.size);

        this.$el.find("#file-upload-progress-text-" + file.id).html(Confluence.Templates.Mobile.PhotoUpload.progressText({
            fileId: file.id,
            uploaded: loadedNiceSize,
            total: totalNiceSize
        }));
    }
});
