define('confluence/convert-page-to-blogpost-dialog-analytics', ['confluence/api/event'], function (event) {
    'use strict';

    function triggerConvertPageToBlogModalConvertClickedEvent(pageId) {
        event.trigger('analyticsEvent', {
            name: 'confluence.convert-page-to-blog.modal.convert.clicked',
            data: {
                pageId: pageId,
            },
        });
    }

    function triggerConvertPageToBlogModalConvertSuccessEvent(pageId) {
        event.trigger('analyticsEvent', {
            name: 'confluence.convert-page-to-blog.modal.convert.success',
            data: {
                pageId: pageId,
            },
        });
    }

    function triggerConvertPageToBlogModalConvertFailureEvent(pageId, httpStatusCode) {
        event.trigger('analyticsEvent', {
            name: 'confluence.convert-page-to-blog.modal.convert.failure',
            data: {
                pageId: pageId,
                httpStatusCode: httpStatusCode,
            },
        });
    }

    return {
        triggerConvertPageToBlogModalConvertClickedEvent,
        triggerConvertPageToBlogModalConvertSuccessEvent,
        triggerConvertPageToBlogModalConvertFailureEvent,
    };
});
