/**
 * @module confluence/page-move-dialog-autocomplete
 */
define('confluence/page-move-dialog-autocomplete', [
    'jquery'
], function(
    $
) {
    'use strict';

    return function(url, appendTo, notFoundTemplate, selectionHandler) {
        var handler = selectionHandler;
        return $(this).quicksearch(url, null, {
            addDropdownData: function(matrix) {
                matrix.pop(); // Don't show <li> "Search for.."
                return matrix;
            },
            dropdownPostprocess: function(list) {
                const $listbox = $(list).find('> ol[role="listbox"]');
                if (!$listbox.find('li').length) { // empty <ol>
                    $listbox.append(notFoundTemplate);
                }
            },
            dropdownPlacement: function(dropDown) {
                $(appendTo).append(dropDown);
            },
            ajsDropDownOptions: {
                selectionHandler: function(e, selected) {
                    if (selected) {
                        this.hide('selected');
                        handler(e, selected);
                        e.preventDefault();
                    }
                }
            }
        });
    };
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence/page-move-dialog-autocomplete', 'jQuery.fn.movePageAutocomplete');
