/* eslint @atlassian/confluence-server/must-use-amd:0 */
/* global $, AJS */
(function($) {
    'use strict';

    var module = QUnit.module;
    var test = QUnit.test;
    AJS.test.require('confluence.aui.staging:confluence-flags', function() {
        module('Confluence flag tests', {
            beforeEach: function() {
                this.flag = require('confluence/flag');
            },
            afterEach: function() {
                $('#aui-flag-container').remove();
            }
        });

        test('Flag fires aui-flag-show event when displayed', function(assert) {
            var done = assert.async();
            assert.expect(1);
            var listener = function() {
                document.removeEventListener('aui-flag-show', listener);
                assert.ok(true);
                done();
            };
            document.addEventListener('aui-flag-show', listener);
            var flag = new this.flag({});
        });

        test('Flag \'stack\' option places flags in same stack', function(assert) {
            var flag1 = new this.flag({
                title: 'First flag',
                stack: 'default'
            });
            var flag2 = new this.flag({
                title: 'Second flag',
                stack: 'default'
            });
            assert.strictEqual($('.aui-flag-stack').attr('data-aui-flag-stack'), 'default');
            assert.strictEqual($('.aui-flag-stack .aui-flag').length, 2);
            assert.ok($(flag1).hasClass('aui-flag-stack-top-item'));
        });

        test('Flag extraClasses attribute appends additional classes to stack', function(assert) {
            var flag = new this.flag({
                extraClasses: 'mock-class'
            });
            assert.ok($('.aui-flag').hasClass('mock-class'));
        });

        test('Flag \'fifo\' attribute places flags at the top of the stack when set to true', function(assert) {
            var flag1 = new this.flag({
                title: 'First flag',
                stack: 'default'
            });
            var flag2 = new this.flag({
                title: 'Second flag',
                stack: 'default',
                fifo: true
            });
            assert.ok($(flag2).hasClass('aui-flag-stack-top-item'));
        });

        test('Flag should parse html body', function(assert) {
            var flag = this.flag({
                title: 'Title',
                body: '<p>paragraph</p><script></script>',
                type: 'success',
                close: 'manual',
            });

            var expectedTemplate = '<div class="aui-flag " aria-live="polite" open="open" aria-hidden="false">' +
                '<div class="aui-message aui-message-success success closeable shadowed">' +
                    '<h2 class="title">' +
                        '<strong>Title</strong>' +
                    '</h2>' +
                    '<p>paragraph</p><script></script>' +
                    '<button type="button" class="aui-close-button" aria-label="Close"></button>' +
                '</div>' +
            '</div>';

            assert.strictEqual(flag.outerHTML, expectedTemplate);
        });

        test('Flag should escape title', function(assert) {
            var flag = this.flag({
                title: '<b>double</b>',
                type: 'success',
            });

            assert.strictEqual($(flag).find('.title').html(), '<strong>&lt;b&gt;double&lt;/b&gt;</strong>');
        });

        test('Flag should have closable class if `close` option NOT `never`', function(assert) {
            var flag = this.flag({
                type: 'success',
                close: 'auto'
            });

            assert.ok($(flag).find('.aui-message').hasClass('closeable'));
        });

        test('Flag should NOT have closable class if `close` option IS `never`', function(assert) {
            var flag = this.flag({
                type: 'success',
                close: 'never'
            });

            assert.notOk($('.aui-message', $(flag)).hasClass('closeable'));
        });

        test('Flag should have extra classes`', function(assert) {
            var flag = this.flag({
                type: 'success',
                extraClasses: 'classA classB'
            });

            assert.ok($(flag).hasClass('classA'));
            assert.ok($(flag).hasClass('classB'));
        });
    });
}($));
