/**
 * Load the Code Macro resources via WRM.require(). This avoids any extra blocking resources being added to the <head>
 */
define('confluence/code-macro/async-loader', ['jquery', 'wrm', 'underscore'], function ($, WRM, _) {
    return function () {
        _.defer(function () {
            const $controlButtons = $('.codeHeader .collapse-source');
            _showSpinner($controlButtons);
            const $codeBlocks = $('#content, div.cq-viewquestion, div.view-template').find('pre.syntaxhighlighter-pre');

            const wrmResources = [];
            const wrmPrefix = 'wr!com.atlassian.confluence.ext.newcode-macro-plugin:';

            if ($codeBlocks.length > 0) {
                wrmResources.push('wrc!code-macro-ak');
            }

            WRM.require(wrmResources).done(function () {
                _hideSpinner($controlButtons);
            });
        });

        /**
         * Hide the expand/collapse buttons until the highlighter is finished, and show a spinner instead
         * @param $controlButtons The expand/collapse buttons
         * @private
         */
        function _showSpinner($controlButtons) {
            $controlButtons.hide();
            // Avoiding searching the entire dom again
            _.forEach($controlButtons, function (button) {
                $(button).next('.collapse-spinner-wrapper').spin();
            });
        }

        /**
         * Show the expand/collapse buttons and hide the spinner once the highlighter is ready.
         * @param $controlButtons The expand/collapse buttons
         * @private
         */
        function _hideSpinner($controlButtons) {
            $controlButtons.show();
            $controlButtons.next('.collapse-spinner-wrapper').remove();
        }
    };
});

require('confluence/module-exporter').safeRequire('confluence/code-macro/async-loader', function (CodeMacroLoader) {
    AJS.toInit(CodeMacroLoader);
});
